<?php

namespace App\ApiRequest\DataPreprocessing;

use DateTimeZone;

class PostTimezoneFilter
{
    /**
     * @param string|null $postTimezone
     * @return string
     * @throws TimezoneNotSpecifiedException
     */
    public static function getCurtz(?string $postTimezone): string
    {
        if (empty($postTimezone)) {
            throw new TimezoneNotSpecifiedException("Timezone must be defined");
        }
        return urldecode($postTimezone);
    }

    /**
     * @throws BadRequestException
     * @throws TimezoneNotSpecifiedException
     */
    public static function getValidatedCurtz(?string $postTimezone): string
    {
        $filtered = static::getCurtz($postTimezone);
        if (!in_array($filtered, DateTimeZone::listIdentifiers())) {
            throw new BadRequestException("Invalid timezone");
        }
        return $filtered;
    }
}
