<?php

namespace App\ApiRequest;

use App\Generators\RandomString;
use App\ShiftsData\GetStopstatuses;
use App\ShiftsData\ProcessStopstatuses;
use CI_Controller;
use SVKAPI\v1\Models\Status;
use Exception;
use Mpdf\MpdfException;
use phpseclib\Net\SFTP;

class SendDocumentGateOut
{
    private static int $loginCounter = 10;

    /**
     * @param $postdata
     * @param CI_Controller $CI
     * @throws MpdfException
     */
    public static function sendepopgateoutnotify($postdata, CI_Controller $CI)
    {
        /*check SDT Ref*/
        $sdtReference = getsdtreforder($postdata['ord_id']);
        $otReference = getOrderTypeReference($postdata['ord_id']);
        if ($sdtReference == ''  && $otReference == 'PUP') {
            $CI->load->library('roadlogsalogdocument');
            $slogData = [
                'order_id' => $postdata['ord_id'],
                'shipment_id' => $postdata['shipment_id'],
            ];
            $CI->roadlogsalogdocument->sendDocumentToSlog($slogData);
            $sdtReference = $otReference;
        }
        if ($sdtReference != 'PUP' && $sdtReference != '') {
            return;
        }
        $orderId = $postdata['ord_id'];
        $ship_id = $postdata['shipment_id'];
        $curtz = $postdata['curtz'];
        $chkcust = $CI->db->query("SELECT o.id,o.order_id,o.user_id,o.pickup_city,o.delivery_city,o.physicalreceiver,o.logicalreceiver,o.physicalsender,o.logicalsender,o.pickup_address1,o.delivery_address1,c.gcm_id,o.company_code,o.branch_code,o.created_source,c.name,c.phone,c.code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id=? LIMIT 1", [$orderId]);
        if ($chkcust->num_rows() == 0) {
            return;
        }
        $data['order'] = $orddata = $chkcust->row_array();
        $ordid = $orddata['id'];
        $order_id = $orddata['order_id'];
        $data['userid'] = $user_id = $orddata['user_id'];
        $company_code = $orddata['company_code'];
        $branch_code = $orddata['branch_code'];
        $createdsource = $orddata['created_source'];
        $rlgRefVal = $CI->common->gettblrowdata(['order_id' => $ordid, 'reference_id' => 'RLG'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
        if ($createdsource == 5) {
            $CI->load->library('salogintegrateservice');
            //log_message("error", "salog SendDocumentGateOut POP " . json_encode($postdata));
            $CI->salogintegrateservice->sendePodToSalog(['ord_id' => $ordid], 'PUP');
        }
        if ($createdsource == 18 || (count($rlgRefVal) > 0)) {
            //log_message("error", "salog Order RLG SendDocumentGateOut POD " . json_encode($postdata));
            $createdsource = 18;
            $getDocumentType = $CI->common->checkDocumentSentType($postdata['ord_id']);
            if ($getDocumentType == 1) {
                $CI->load->library('Roadlogsalogdocument');
                $CI->roadlogsalogdocument->sendCarrierPODtoRoadlog($ordid,"PUP", $CI);
                return 1;
            }
            $data["pod"] = self::getOrderDocuments($curtz, $ordid, $createdsource, $ship_id, $CI);
            $data["orderref"] = $CI->common->getallorderreferences($ordid);
            $CI->load->library('m_pdf');
            $refvalue = $orderDepartmentCode = "";
            $departmentCode = $CI->common->gettblrowdata(['order_row_id' => $ordid], "department_code", "tb_order_details", 0, 0);
            if (!empty($departmentCode)) {
                $orderDepartmentCode = $departmentCode['department_code'];
            }
            $iofeof = "EOF";
            $orderReferences = $CI->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1", [$ordid]);
            [$bn, $inn, $iv, $dq, $cmp, $brn, $refvalue] = self::extractOrderReferences($orderReferences, $refvalue);
            $stops = GetStopstatuses::getStopstatuses($curtz, $ship_id, $CI->db);
            [$dataStops, $dataPickupDatetime, $dataDeliveryDatetime] = ProcessStopstatuses::processStopstatuses($stops);
            $data['stops'] = $dataStops;
            $data['pickup_datetime'] = $dataPickupDatetime;
            $data['delivery_datetime'] = $dataDeliveryDatetime;
            $data['comment'] = $postdata['comment'] ?? '';
            $html = $CI->load->view('settings/bulkepod', $data, true);
            $epodpath = getEpodPath($order_id);
            $CI->m_pdf->resetInstance();
            $CI->m_pdf->pdf->WriteHTML($html);
            $CI->m_pdf->pdf->Output($epodpath, "F");
            $pagescnt = $CI->m_pdf->pdf->pages;
            $pages = count($pagescnt);
            $RLGTrackingNumber =  (count($rlgRefVal) > 0) ? $rlgRefVal['ref_value'] :  $order_id;


            $jplData = [
                "country" => substr($company_code, 0, -2),
                "branch" => substr($branch_code, 2),
                "order_id" => $RLGTrackingNumber,
                "time" => date("hi"),
                "date" => date("d.m.Y"),
                "pages" => $pages,
                "doctype" => 999,
                "senderInst" => self::getEnvironment($orddata['physicalsender']),
                "epod_path" => $epodpath
            ];
            $jplFilePath = self::saveJPF($jplData, $CI);
            $uploadStatus = self::uploadKnFiles([$jplFilePath, $epodpath]);

        } else {
            $data["pod"] = self::getOrderDocuments($curtz, $ordid, $createdsource, $ship_id, $CI);
            $data["orderref"] = $CI->common->getallorderreferences($ordid);
            $CI->load->library('m_pdf');
            $refvalue = $orderDepartmentCode = "";
            $departmentCode = $CI->common->gettblrowdata(['order_row_id' => $ordid], "department_code", "tb_order_details", 0, 0);
            if (!empty($departmentCode)) {
                $orderDepartmentCode = $departmentCode['department_code'];
            }
            $iofeof = "EOF";
            $orderReferences = $CI->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1", [$ordid]);
            [$bn, $inn, $iv, $dq, $cmp, $brn, $refvalue] = self::extractOrderReferences($orderReferences, $refvalue);
            $stops = GetStopstatuses::getStopstatuses($curtz, $ship_id, $CI->db);
            [$dataStops, $dataPickupDatetime, $dataDeliveryDatetime] = ProcessStopstatuses::processStopstatuses($stops);
            $data['stops'] = $dataStops;
            $data['pickup_datetime'] = $dataPickupDatetime;
            $data['delivery_datetime'] = $dataDeliveryDatetime;
            $data['comment'] = $postdata['comment'] ?? '';
            $html = $CI->load->view('settings/bulkepod', $data, true);
            $epodpath = getEpodPath($order_id);
            $CI->m_pdf->resetInstance();
            $CI->m_pdf->pdf->WriteHTML($html);
            $CI->m_pdf->pdf->Output($epodpath, "F");
            $pagescnt = $CI->m_pdf->pdf->pages;
            $pages = count($pagescnt);
            $jplData = [
                "country" => substr($company_code, 0, -2),
                "branch" => substr($branch_code, 2),
                "order_id" => $order_id,
                "time" => date("hi"),
                "date" => date("d.m.Y"),
                "pages" => $pages,
                "doctype" => 999,
                "senderInst" => self::getEnvironment($orddata['physicalsender'] ?? ""),
                "epod_path" => $epodpath
            ];
            $jplFilePath = self::saveJPF($jplData, $CI);
            $uploadStatus = self::uploadKnFiles([$jplFilePath, $epodpath]);
        }
        return $uploadStatus['status'] ?? 0;
    }

    /**
     * @param $curtz
     * @param $ordid
     * @param $createdsource
     * @param $ship_id
     * @param CI_Controller $CI
     * @return array
     */
    private static function getOrderDocuments(string $curtz, int $ordid, int $createdsource, int $ship_id, CI_Controller $CI): object
    {
        $data = $CI->db->query(
            "SELECT ts.id, ts.latitude, ts.longitude, ts.stop_id, ts.stop_type, dt.type_name,ts.createdby,
                        convertToClientTZ(ts.createdon, ?) as createdon, ts.imgpath,ts.hash, e.address, e.pickup,
                        e.drop,e.order_id
                        FROM tb_pod_uploads ts
                        INNER JOIN tb_document_types dt
                            ON dt.id = ts.doc_type
                        LEFT JOIN tb_employee e
                            ON e.id = ts.stop_detail_id
                        WHERE ts.order_id = ? AND ts.status=? AND ts.stop_type = ?
                        GROUP BY ts.id
                        ORDER BY ts.createdon ASC",
            [$curtz, $ordid, 1, 'P']
        );
        // SALOG Created Source is 5
        if ($createdsource != 5 and $data->num_rows() == 0) {
            $data = $CI->db->query(
                "SELECT ts.id, ts.latitude, ts.longitude, ts.stop_id, ts.stop_type, dt.type_name, ts.createdby,
                            convertToClientTZ(ts.createdon, ?) as createdon, ts.imgpath,ts.hash, e.address, e.pickup, e.drop, e.order_id
                            FROM tb_pod_uploads ts
                            LEFT JOIN tb_document_types dt
                                ON dt.id = ts.doc_type
                            LEFT JOIN tb_employee e
                                ON e.id = ts.stop_detail_id
                            WHERE ts.shipment_id = ? AND ts.status = ? AND ts.stop_type = ?
                            GROUP BY ts.id
                            ORDER BY ts.createdon ASC",
                [$curtz, $ship_id, 1, 'P']
            );
        }
        return $data;
    }

    /**
     * @param $order_id
     * @param $pickaddr
     * @param $deliveryaddr
     * @param $user_id
     * @param $chkdocs
     * @param CI_Controller $CI
     * @param $ordid
     * @param $curtz
     * @param $ship_id
     * @param string $epodpath
     * @param $company_code
     * @param $branch_code
     * @param $custcid
     * @param $custcode
     * @return array
     * @throws MpdfException
     */
    private static function generateJPLData($order_id, $pickaddr, $deliveryaddr, $user_id, $chkdocs, CI_Controller $CI, $ordid, $curtz, $ship_id, string $epodpath, $company_code, $branch_code, $custcid, $custcode): array
    {
        $refvalue = $orderDepartmentCode = "";
        /*get department code for this order*/
        $departmentCode = $CI->common->gettblrowdata(['order_row_id' => $ordid], "department_code", "tb_order_details", 0, 0);
        if (!empty($departmentCode)) {
            $orderDepartmentCode = $departmentCode['department_code'];
        }
        $pages = self::generateBulkEPodPDF($order_id, $pickaddr, $deliveryaddr, $user_id, $chkdocs, $CI, $ordid, $curtz, $ship_id, $epodpath);
        $unique_id = "RL" . $order_id . "." . date("Ymd") . "." . date("his");
        /* SALog JPL*/
        $chkordtypeqry1 = $CI->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1", [$ordid]);
        [$bn, $inn, $iv, $dq, $cmp, $brn, $refvalue] = self::extractOrderReferences($chkordtypeqry1, $refvalue);
        if ($cmp == "") {
            $cmp = $company_code;
        }
        if ($brn == "") {
            $brn = $branch_code;
        }
        $countrycode = substr($company_code, 0, -2);
        $randomstr = RandomString::generate(10);
        $jplData = [
            "country" => $cmp,
            "branch" => $brn,
            "order_id" => $order_id,
            "time" => date("hi"),
            "unique_id" => $unique_id,
            "date" => date("d.m.Y"),
            "pages" => $pages,
            "xsr" => $refvalue,
            "sd" => $orderDepartmentCode,
            "bn" => $bn,
            "inn" => $inn,
            "iv" => $iv,
            "dq" => $dq,
            "custcid" => $custcid,
            "custcode" => $custcode,
            "countrycode" => $countrycode,
            "randomstr" => $randomstr,
            "doctype" => 171
        ];
        return $jplData;
    }

    /**
     * @param $order_id
     * @param $pickaddr
     * @param $deliveryaddr
     * @param $user_id
     * @param $chkdocs
     * @param CI_Controller $CI
     * @param $ordid
     * @param $curtz
     * @param $ship_id
     * @param string $epodpath
     * @throws MpdfException
     */
    private static function generateBulkEPodPDF($order_id, $pickaddr, $deliveryaddr, $user_id, $chkdocs, CI_Controller $CI, $ordid, $curtz, $ship_id, string $epodpath): int
    {
        $data['order'] = ["order_id" => $order_id, "pickup_address1" => $pickaddr, "delivery_address1" => $deliveryaddr];
        $data['userid'] = $user_id;
        $data["pod"] = $chkdocs;
        $data["orderref"] = $CI->common->getallorderreferences($ordid);
        $data['pickup_datetime'] = "";
        $data['delivery_datetime'] = "";
        $stops = $CI->db->query("SELECT ss.stop_type,ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,?) as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=? AND ss.status='1' ORDER BY ss.createdon ASC",[$curtz, $ship_id]);
        if ($stops->num_rows() > 0) {
            foreach ($stops->result() as $sres) {
                if ($sres->status_id == "1" && $sres->stop_type == "P") {
                    $data['pickup_datetime'] = $sres->createdon;
                }
                if ($sres->status_id == "1" && $sres->stop_type == "D") {
                    $data['delivery_datetime'] = $sres->createdon;
                }
            }
        }
        $CI->load->library('m_pdf');
        $html = $CI->load->view('settings/bulkepod', $data, true);
        $CI->m_pdf->resetInstance();
        @$CI->m_pdf->pdf->WriteHTML($html);
        @$CI->m_pdf->pdf->Output($epodpath, "F");
        $pages = $CI->m_pdf->pdf->pages;
        return count($pages);
    }

    /**
     * @param $chkordtypeqry1
     * @param $refvalue
     * @return array
     */
    private static function extractOrderReferences($chkordtypeqry1, $refvalue): array
    {
        $bn = $inn = $iv = $dq = $cmp = $brn = "";
        if ($chkordtypeqry1->num_rows() > 1) {
            foreach ($chkordtypeqry1->result() as $oref1) {
                if ($oref1->reference_id == "BN") {
                    $bn = $oref1->ref_value;
                }
                if ($oref1->reference_id == "INN") {
                    $inn = $oref1->ref_value;
                }
                if ($oref1->reference_id == "IV") {
                    $iv = $oref1->ref_value;
                }
                if ($oref1->reference_id == "DQ") {
                    if (strlen($oref1->ref_value) > 11 && (strpos($oref1->ref_value, 'O') !== false)) {
                        $dq = $oref1->ref_value;
                    }
                }
                if ($oref1->reference_id == "CMP") {
                    $cmp = $oref1->ref_value;
                }
                if ($oref1->reference_id == "BRN") {
                    $brn = $oref1->ref_value;
                }
                if ($oref1->reference_id == "XSR") {
                    $refvalue = $oref1->ref_value;
                }
            }
        }
        return [$bn, $inn, $iv, $dq, $cmp, $brn, $refvalue];
    }

    /**
     * @param $jplData
     * @param CI_Controller $CI
     * @return string
     */
    public static function saveSalogJPF($jplData, CI_Controller $CI): string
    {
        $order_id = $jplData["order_id"];
        $file_path = getJplPath($order_id);
        $jplData["unique_id"] = basename($file_path, ".jpl");
        $content = $CI->load->view("jpl_salogtemplate", $jplData, true);
        $fp = fopen($file_path, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $file_path;
    }

    /**
     * @param $localfile
     * @return bool
     */
    public static function uploadSalogKNFile($localfile): bool
    {
        $remotefile = basename($localfile);
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        $folder_name = "/pub/inbound/D3/IF";
        try {
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                log_message("error", "Cannot login into your SALOG MTF Test server !");
            } else {
                $sftp->chdir($folder_name);
                $sftp->put($folder_name . "/" . $remotefile, $localfile, SFTP::SOURCE_LOCAL_FILE);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, SALOG MTF Test server, Please Try Again Later.");
        }
        return false;
    }

    /**
     * @param $postdata
     * @param CI_Controller $CI
     * @throws MpdfException
     */
    public static function sendepodgateoutnotify($postdata, CI_Controller $CI)
    {
        $sdtref = getsdtreforder($postdata['ord_id']);
        if ($sdtref != 'DEL' && $sdtref != '') {
            return;
        }
        //("error","sendepodgateoutnotify 1 Payload ".json_encode($postdata));
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $curtz = $postdata['curtz'];
        $chkcust = $CI->db->query(
            "SELECT o.id,o.order_id,o.pickup_company,o.pickup_country,o.pickup_pincode,o.delivery_company,o.delivery_country,o.delivery_pincode,o.quantity,o.weight,o.volume,o.user_id,o.customer_id,o.company_code,o.branch_code,o.created_source, c.name, c.phone, c.code,o.pickup_city,o.delivery_city,o.physicalreceiver,o.logicalreceiver,o.physicalsender,o.logicalsender,o.pickup_address1,o.delivery_address1,c.gcm_id
                FROM tb_orders o, tb_customers c
                WHERE o.customer_id = c.id
                AND o.order_id = ? LIMIT 1",
            [$order_id]
        );
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $user_id = $orddata['user_id'];
            $company_code = $orddata['company_code'];
            $branch_code = $orddata['branch_code'];
            $customerId = $orddata['customer_id'];
            $checkEpodForCustomer = false;
            if (checkAccessConditions('SEND_EPOD_TO_SELECTED_CUSTOMERS', $customerId)) {
                $checkEpodForCustomer = true;
                $CI->load->model(['Roadlogtosalogmodel']);
                $customerGroupEmailIds = $CI->Roadlogtosalogmodel->getCustomerGroupEmailIds($customerId);
            }
            $rlgRefVal = $CI->common->gettblrowdata(['order_id' => $ordid, 'reference_id' => 'RLG'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
            if ($orddata['created_source'] == 5) {
                $CI->load->library('salogintegrateservice');
                //log_message("error", "salog SendDocumentGateOut POD " . json_encode($postdata));
                $CI->salogintegrateservice->sendePodToSalog(['ord_id' => $ordid], 'DEL');
            }
            if ($orddata['created_source'] == 18 || (count($rlgRefVal) > 0) || $checkEpodForCustomer) {
                $orddata['created_source'] = 18;
                //log_message("error", "salog Order RLG SendDocumentGateOut POD " . json_encode($postdata));
                $getDocumentType = $CI->common->checkDocumentSentType($postdata['ord_id']);
                if ($getDocumentType == 1) {
                    $CI->load->library('Roadlogsalogdocument');
                    $CI->roadlogsalogdocument->sendCarrierPODtoRoadlog($ordid,"POD", $CI);
                    return 1;
                }
                $chkadminusr = $CI->db->query(
                    "SELECT name, emailid, cc_mails
                    FROM tb_users
                    WHERE id = ?
                      AND emailid != ''
                    LIMIT 1",
                    [$user_id]
                );
                if ($chkadminusr->num_rows() > 0) {
                    $CI->load->library('email');
                    $receivename = $chkadminusr->row()->name;
                    $receivemail = $chkadminusr->row()->emailid;
                    $ccmail = [];
                    if ($chkadminusr->row()->cc_mails != "") {
                        $ccmail[] = $chkadminusr->row()->cc_mails;
                    }
                    if (!empty($customerGroupEmailIds ?? [])) {
                        $ccmail = array_merge($customerGroupEmailIds, $ccmail);
                    }
                    $data['order'] = $orddata;
                    $data['userid'] = $user_id;
                    $data['pickup_company'] = $orddata['pickup_company'];
                    $data['pickup_country'] = $orddata['pickup_country'];
                    $data['pickup_pincode'] = $orddata['pickup_pincode'];
                    $data['delivery_company'] = $orddata['delivery_company'];
                    $data['delivery_country'] = $orddata['delivery_country'];
                    $data['delivery_pincode'] = $orddata['delivery_pincode'];
                    $data['quantity'] = $orddata['quantity'];
                    $data['weight'] = $orddata['weight'];
                    $data['volume'] = $orddata['volume'];
                    $data["pod"] = $ordpods = $CI->db->query(
                        "SELECT ts.id, ts.latitude, ts.longitude, ts.stop_id, ts.stop_type, dt.type_name, ts.createdby,
                        convertToClientTZ(ts.createdon, ?) as createdon, ts.imgpath,ts.hash, e.address, e.pickup, e.drop, e.order_id
                            FROM tb_pod_uploads ts
                            INNER JOIN tb_document_types dt
                                ON dt.id = ts.doc_type
                            LEFT JOIN tb_employee e
                                ON e.id = ts.stop_detail_id
                            WHERE ts.order_id = ? AND ts.status = ? AND ts.stop_type = ?
                            GROUP BY ts.id
                            ORDER BY ts.createdon ASC",
                        [$curtz, $ordid, 1, 'D']
                    );
                    if ($ordpods->num_rows() == 0) {
                        $data["pod"] = $CI->db->query(
                            "SELECT ts.id, ts.latitude, ts.longitude, ts.stop_id, ts.stop_type, dt.type_name, ts.createdby,
                            convertToClientTZ(ts.createdon, ?) as createdon, ts.imgpath,ts.hash, e.address, e.pickup, e.drop, e.order_id
                            FROM tb_pod_uploads ts
                            LEFT JOIN tb_document_types dt
                                ON dt.id = ts.doc_type
                            LEFT JOIN tb_employee e
                                ON e.id = ts.stop_detail_id
                            WHERE ts.shipment_id = ? AND ts.status = ? AND ts.stop_type = ?
                            GROUP BY ts.id
                            ORDER BY ts.createdon ASC",
                            [$curtz, $ship_id, 1, 'D']
                        );
                    }
                    $data["orderref"] = $CI->common->getallorderreferences($ordid);
                    $CI->load->library('m_pdf');
                    if (checkAccessConditions('CHANGE_EPOD_EMAIL_SUBJECT_WITH_DQ_PO', $company_code)) {
                        $checkOrderReferences = $CI->common->getOrderDQPOReferences($ordid);
                        $subRef = "";
                        foreach ($checkOrderReferences as $orderReference) {
                            $subRef .= " " . $orderReference->ref_value;
                        }
                        $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $subRef . " ";
                    } else {
                        $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $order_id . " ";
                    }
                    $data['page_title'] = "Trip ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $chkref = "XSR";
                    $refvalue = $newsub = "";
                    $iofeof = "EOF";
                    $chkordtypeqry1 = $CI->db->query(
                        "SELECT reference_id, ref_value
                        FROM tb_order_references
                        WHERE order_id = ?
                          AND ref_value != ''
                        GROUP BY reference_id
                        HAVING count(reference_id) >= 1",
                        [$ordid]
                    );
                    if ($chkordtypeqry1->num_rows() > 1) {
                        foreach ($chkordtypeqry1->result() as $oref1) {
                            if ($oref1->reference_id == "XSR") {
                                $refvalue = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "SD" && $oref1->ref_value == "2") {
                                $iofeof = "IOF";
                            }
                        }
                    }
                    $stops = GetStopstatuses::getStopstatuses($curtz, $ship_id, $CI->db);
                    [$dataStops, $dataPickupDatetime, $dataDeliveryDatetime] = ProcessStopstatuses::processStopstatuses($stops);
                    $data['stops'] = $dataStops;
                    $data['pickup_datetime'] = $dataPickupDatetime;
                    $data['delivery_datetime'] = $dataDeliveryDatetime;
                    $data['comment'] = $postdata['comment'] ?? '';
                    $html = $CI->load->view('settings/bulkepod', $data, true);
                    $epodpath = getEpodPath($order_id);
                    $CI->m_pdf->resetInstance();
                    $CI->m_pdf->pdf->WriteHTML($html);
                    $CI->m_pdf->pdf->Output($epodpath, "F");
                    $pagescnt = $CI->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    $data['mailtype'] = "ePOD";
                    if ($refvalue != "") {
                        $newsub = $refvalue . "#746#" . $iofeof;
                        $sub .= $chkref . ":" . $refvalue . "#746#" . $iofeof . "";
                        $query = $CI->db->query(
                            "SELECT emailid,party_name
                            FROM tb_contact_notifys
                            WHERE status = 1
                              AND (pod_note = 1 OR all_note = 1)
                            GROUP BY emailid"
                        );
                        if ($query->num_rows() > 0) {
                            foreach ($query->result() as $pmails) {
                                $ccmail[] = $pmails->emailid;
                            }
                        }
                    }
                    if ($newsub == "") {
                        $newsub = $sub;
                    }
                    $CI->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $CI->email->to($receivemail);
                    if (!empty($ccmail)) {
                        $ccmail = array_unique($ccmail);
                        $cc_mail = implode(", ", $ccmail);
                        $cc_mail = '"' . $cc_mail . '"';
                        $CI->email->cc($cc_mail);
                    }
                    $CI->email->subject($newsub);
                    $CI->email->set_mailtype("html");
                    $body = $CI->load->view('mail_forms/deliveredshipment', $data, true);
                    $RLGTrackingNumber =  (count($rlgRefVal) > 0) ? $rlgRefVal['ref_value'] :  $order_id;
                    $jplData = [
                        "country" => substr($company_code, 0, -2),
                        "branch" => substr($branch_code, 2),
                        "order_id" => $RLGTrackingNumber,
                        "time" => date("hi"),
                        "date" => date("d.m.Y"),
                        "pages" => $pages,
                        "doctype" => 545,
                        "senderInst" => self::getEnvironment($orddata['physicalsender']),
                        "epod_path" => $epodpath
                    ];
                    $jplFilePath = self::saveJPF($jplData, $CI);
                    self::$loginCounter = 10;
                    $uploadStatus = self::uploadKnFiles([$jplFilePath, $epodpath]);
                    $fileName = "RL" . $order_id . ".pdf";
                    $epodpath = sprintf('%s/assets/trippods/%s', FCPATH, $fileName);
                    $CI->email->message($body);
                    $CI->email->attach($epodpath);
                    if (false === $CI->email->send()) {
                        log_message("error", $CI->email->print_debugger());
                    }
                    $CI->email->clear(true);
                }
            } else {
                $chkadminusr = $CI->db->query(
                    "SELECT name, emailid, cc_mails
                    FROM tb_users
                    WHERE id = ?
                      AND emailid != ''
                    LIMIT 1",
                    [$user_id]
                );
                if ($chkadminusr->num_rows() > 0) {
                    $CI->load->library('email');
                    $receivename = $chkadminusr->row()->name;
                    $receivemail = $chkadminusr->row()->emailid;
                    $ccmail = [];
                    if ($chkadminusr->row()->cc_mails != "") {
                        $ccmail[] = $chkadminusr->row()->cc_mails;
                    }
                    $data['order'] = $orddata;
                    $data['userid'] = $user_id;
                    $data['pickup_company'] = $orddata['pickup_company'];
                    $data['pickup_country'] = $orddata['pickup_country'];
                    $data['pickup_pincode'] = $orddata['pickup_pincode'];
                    $data['delivery_company'] = $orddata['delivery_company'];
                    $data['delivery_country'] = $orddata['delivery_country'];
                    $data['delivery_pincode'] = $orddata['delivery_pincode'];
                    $data['quantity'] = $orddata['quantity'];
                    $data['weight'] = $orddata['weight'];
                    $data['volume'] = $orddata['volume'];
                    $data["pod"] = $ordpods = $CI->db->query(
                        "SELECT ts.id, ts.latitude, ts.longitude, ts.stop_id, ts.stop_type, dt.type_name, ts.createdby,
                        convertToClientTZ(ts.createdon, ?) as createdon, ts.imgpath,ts.hash, e.address, e.pickup, e.drop, e.order_id
                            FROM tb_pod_uploads ts
                            INNER JOIN tb_document_types dt
                                ON dt.id = ts.doc_type
                            LEFT JOIN tb_employee e
                                ON e.id = ts.stop_detail_id
                            WHERE ts.order_id = ? AND ts.status = ? AND ts.stop_type = ?
                            GROUP BY ts.id
                            ORDER BY ts.createdon ASC",
                        [$curtz, $ordid, 1, 'D']
                    );
                    if ($ordpods->num_rows() == 0) {
                        $data["pod"] = $CI->db->query(
                            "SELECT ts.id, ts.latitude, ts.longitude, ts.stop_id, ts.stop_type, dt.type_name, ts.createdby,
                            convertToClientTZ(ts.createdon, ?) as createdon, ts.imgpath,ts.hash, e.address, e.pickup, e.drop, e.order_id
                            FROM tb_pod_uploads ts
                            LEFT JOIN tb_document_types dt
                                ON dt.id = ts.doc_type
                            LEFT JOIN tb_employee e
                                ON e.id = ts.stop_detail_id
                            WHERE ts.shipment_id = ? AND ts.status = ? AND ts.stop_type = ?
                            GROUP BY ts.id
                            ORDER BY ts.createdon ASC",
                            [$curtz, $ship_id, 1, 'D']
                        );
                    }
                    $data["orderref"] = $CI->common->getallorderreferences($ordid);
                    $CI->load->library('m_pdf');
                    if (checkAccessConditions('CHANGE_EPOD_EMAIL_SUBJECT_WITH_DQ_PO', $company_code)) {
                        $checkOrderReferences = $CI->common->getOrderDQPOReferences($ordid);
                        $subRef = "";
                        foreach ($checkOrderReferences as $orderReference) {
                            $subRef .= " " . $orderReference->ref_value;
                        }
                        $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $subRef . " ";
                    } else {
                        $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $order_id . " ";
                    }
                    $data['page_title'] = "Trip ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $chkref = "XSR";
                    $refvalue = $newsub = "";
                    $iofeof = "EOF";
                    $chkordtypeqry1 = $CI->db->query(
                        "SELECT reference_id, ref_value
                        FROM tb_order_references
                        WHERE order_id = ?
                          AND ref_value != ''
                        GROUP BY reference_id
                        HAVING count(reference_id) >= 1",
                        [$ordid]
                    );
                    if ($chkordtypeqry1->num_rows() > 1) {
                        foreach ($chkordtypeqry1->result() as $oref1) {
                            if ($oref1->reference_id == "XSR") {
                                $refvalue = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "SD" && $oref1->ref_value == "2") {
                                $iofeof = "IOF";
                            }
                        }
                    }
                    $stops = GetStopstatuses::getStopstatuses($curtz, $ship_id, $CI->db);
                    [$dataStops, $dataPickupDatetime, $dataDeliveryDatetime] = ProcessStopstatuses::processStopstatuses($stops);
                    $data['stops'] = $dataStops;
                    $data['pickup_datetime'] = $dataPickupDatetime;
                    $data['delivery_datetime'] = $dataDeliveryDatetime;
                    $data['comment'] = $postdata['comment'] ?? '';
                    $html = $CI->load->view('settings/bulkepod', $data, true);
                    $epodpath = getEpodPath($order_id);
                    $CI->m_pdf->resetInstance();
                    $CI->m_pdf->pdf->WriteHTML($html);
                    $CI->m_pdf->pdf->Output($epodpath, "F");
                    $pagescnt = $CI->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    $data['mailtype'] = "ePOD";
                    if ($refvalue != "") {
                        $newsub = $refvalue . "#746#" . $iofeof;
                        $sub .= $chkref . ":" . $refvalue . "#746#" . $iofeof . "";
                        $query = $CI->db->query(
                            "SELECT emailid,party_name
                            FROM tb_contact_notifys
                            WHERE status = 1
                              AND (pod_note = 1 OR all_note = 1)
                            GROUP BY emailid"
                        );
                        if ($query->num_rows() > 0) {
                            foreach ($query->result() as $pmails) {
                                $ccmail[] = $pmails->emailid;
                            }
                        }
                    }
                    if ($newsub == "") {
                        $newsub = $sub;
                    }
                    $CI->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $CI->email->to($receivemail);
                    if (!empty($ccmail)) {
                        $ccmail = array_unique($ccmail);
                        $cc_mail = implode(", ", $ccmail);
                        $cc_mail = '"' . $cc_mail . '"';
                        $CI->email->cc($cc_mail);
                    }
                    $CI->email->subject($newsub);
                    $CI->email->set_mailtype("html");
                    $body = $CI->load->view('mail_forms/deliveredshipment', $data, true);
                    $jplData = [
                        "country" => substr($company_code, 0, -2),
                        "branch" => substr($branch_code, 2),
                        "order_id" => $order_id,
                        "time" => date("hi"),
                        "date" => date("d.m.Y"),
                        "pages" => $pages,
                        "doctype" => 545,
                        "senderInst" => self::getEnvironment($orddata['physicalsender']),
                        "epod_path" => $epodpath
                    ];
                    $jplFilePath = self::saveJPF($jplData, $CI);
                    self::$loginCounter = 10;
                    $uploadStatus = self::uploadKnFiles([$jplFilePath, $epodpath]);
                    $fileName = "RL" . $order_id . ".pdf";
                    $epodpath = sprintf('%s/assets/trippods/%s', FCPATH, $fileName);
                    $CI->email->message($body);
                    $CI->email->attach($epodpath);
                    if (false === $CI->email->send()) {
                        log_message("error", $CI->email->print_debugger());
                    }
                    $CI->email->clear(true);
                }
            }
        }
        return $uploadStatus['status'] ?? 0;
    }

    /**
     * @param $jplData
     * @return string
     */
    public static function saveJPF($jplData, CI_Controller $CI): string
    {
        $basename = basename($jplData["epod_path"], ".pdf");
        $file_path =  "./assets/jpl_files/".$basename.".jpl";
        $jplData["unique_id"] = $basename;
        $content = $CI->load->view("jpl_template", $jplData, true);
        $fp = fopen($file_path, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $file_path;
    }

    /**
     * @param $postdata
     * @param $sts
     * @param CI_Controller $CI
     */
    public static function sendshipstatusnotify($postdata, $sts, CI_Controller $CI)
    {
        $ord_id = $postdata['order_id'] ?? "";
        $chkcust = $CI->db->query("SELECT o.customer_id,o.user_id,c.name,c.gcm_id,c.company_code,c.branch_code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.order_id='" . $ord_id . "' AND c.gcm_id != '' LIMIT 1");
        if ($chkcust->num_rows() > 0) {
            $cust_id = $chkcust->row()->customer_id;
            $cust_name = $chkcust->row()->name;
            $company_code = $chkcust->row()->company_code;
            $branch_code = $chkcust->row()->branch_code;
            $chksend = $CI->db->query("SELECT id,status_name FROM tb_customer_status WHERE customer_id=$cust_id AND status_id=$sts AND company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' AND status=1 LIMIT 1");
            if ($chksend->num_rows() > 0) {
                $sts_name = $chksend->row()->status_name;
                $ship_id = $postdata['shipment_id'];
                $trip_id = $postdata['trip_id'];
                $stop_id = $postdata['stop_id'];
                $stopdetailsid = 0;
                $notifydata = [];
                $stopdetails = $CI->db->query("SELECT id FROM tb_employee WHERE (stop_id='$stop_id' OR drop_stopid='$stop_id') AND shift_id='$ship_id' LIMIT 1");
                if ($stopdetails->num_rows() > 0) {
                    $stopdetailsid = $stopdetails->row()->id;
                }
                if ($sts == 1) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = ["title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0];
                } elseif ($sts == 2) {
                    $stsmsg = $sts_name . " for Pickup";
                    if ($postdata['stop_type'] == "D") {
                        $stsmsg = $sts_name . " for Delivery";
                    }
                    $message = "Dear " . $cust_name . ", Driver updated the " . $stsmsg . " status on your order " . $ord_id . "";
                    $notifydata = [
                        "title" => "Driver Status Update",
                        "message" => $message,
                        "emp_id" => $stopdetailsid,
                        'type' => 'Customer',
                        "shipment_id" => $ship_id,
                        "trip_id" => $trip_id,
                        "stop_id" => $stop_id,
                        "user_id" => $cust_id,
                        "status_id" => $sts,
                        "msg_status" => 0
                    ];
                } elseif ($sts == 3) {
                    $stsmsg = $sts_name . " from Pickup";
                    if ($postdata['stop_type'] == "D") {
                        $stsmsg = $sts_name . " from Delivery";
                    }
                    $message = "Dear " . $cust_name . ", Driver updated the " . $stsmsg . " status on your order " . $ord_id . "";
                    $notifydata = [
                        "title" => "Driver Status Update",
                        "message" => $message,
                        "emp_id" => $stopdetailsid,
                        'type' => 'Customer',
                        "shipment_id" => $ship_id,
                        "trip_id" => $trip_id,
                        "stop_id" => $stop_id,
                        "user_id" => $cust_id,
                        "status_id" => $sts,
                        "msg_status" => 0
                    ];
                } elseif ($sts == 4) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = [
                        "title" => "Driver Status Update",
                        "message" => $message,
                        "emp_id" => $stopdetailsid,
                        'type' => 'Customer',
                        "shipment_id" => $ship_id,
                        "trip_id" => $trip_id,
                        "stop_id" => $stop_id,
                        "user_id" => $cust_id,
                        "status_id" => $sts,
                        "msg_status" => 0
                    ];
                } elseif ($sts == 5) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = [
                        "title" => "Driver Status Update",
                        "message" => $message,
                        "emp_id" => $stopdetailsid,
                        'type' => 'Customer',
                        "shipment_id" => $ship_id,
                        "trip_id" => $trip_id,
                        "stop_id" => $stop_id,
                        "user_id" => $cust_id,
                        "status_id" => $sts,
                        "msg_status" => 0
                    ];
                } elseif ($sts == 6) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = [
                        "title" => "Driver Status Update",
                        "message" => $message,
                        "emp_id" => $stopdetailsid,
                        'type' => 'Customer',
                        "shipment_id" => $ship_id,
                        "trip_id" => $trip_id,
                        "stop_id" => $stop_id,
                        "user_id" => $cust_id,
                        "status_id" => $sts,
                        "msg_status" => 0
                    ];
                }
                @$CI->sendfirebase->sendSingleOrderPush($notifydata);
            }
        }
    }

    /**
     * @param physicalSender string
     * return string As Environment
     */
    private static function getEnvironment(string $physicalSender): string
    {
        switch ($physicalSender) {
            case 'KNRLG01':
                return 'PROD';
            case 'KNRLG09':
                return 'TEST_ACCEPTANCE';
            case 'KNRLG03':
                return 'TEST_SPE';
            default:
                log_debug('Unable to define environement for physical sender \'' . $physicalSender . '\', use TEST');
                return 'TEST';
        }
    }

    private static function uploadKnFiles(array $files): array
    {
        $sftp = new SFTP(SALOG_FTP);
        $folderPath = "/pub/inbound/D3/FO";
        if (!$sftp->login(SALOG_FTP_USER, SALOG_FTP_PWD)) {
            log_message("error","Roadlog SFTP: Cannot login into your Roadlog MTF server ! ".$files[0]);
            return self::repeatLogin($files);
        }
        $sftp->chdir($folderPath);
        foreach ($files as $file) {
            $sftp->put($folderPath . "/" . basename($file), $file, SFTP::SOURCE_LOCAL_FILE);
        }
        return ['status' => 1];
    }

    private static function repeatLogin(array $files): array
    {
        if (!self::$loginCounter--) {
            log_message("error","Roadlog SFTP: login failed! ".json_encode($files));
            return ['status' => 0];
        }
        sleep(random_int(2, 5));
        log_message("error", "Roadlog SFTP, retry login " . self::$loginCounter . " on failure");
        return self::uploadKnFiles($files);
    }
}
