<?php

namespace App\Authorization\Authorizer;

use App\Authorization\Exception\AuthorizationDeniedException;

abstract class EntityAuthorizer implements EntityAuthorizerInterface
{
    /**
     * @var bool
     *
     * If $throwExceptionOnDenial is true, we throw an exception instead of false, to halt application. Currently
     * controllers are unstructured and if we keep application running, unwanted side effect could occur.
     */
    protected $throwExceptionOnDenial = true;

    /**
     * @throws AuthorizationDeniedException
     *
     * Created method to deny authorization, so it is possible to configure if we want to throw an exception or return
     * false. Also it is possible to add logging or event emitting in the future.
     */
    protected function denyAuthorization(): bool
    {
        if ($this->throwExceptionOnDenial) {
            throw new AuthorizationDeniedException;
        }

        return false;
    }

    /**
     * Created method to grant authorization to add logging or event emitting in the future;
     */
    protected function grantAuthorization(): bool
    {
        return true;
    }
}
