<?php

namespace App\Authorization;

use App\Authorization\Authorizer\EntityAuthorizerInterface;
use App\Authorization\Authorizer\OrderEntityAuthorizer;
use App\Authorization\Exception\EntityAuthorizerNotFoundException;

class EntityAuthorizerFactory
{
    private const ENTITY_AUTHORIZERS = [
        Authorization::ENTITY_TYPE_ORDER => OrderEntityAuthorizer::class,
    ];
    private $ciInstance;

    public function __construct($ciInstance)
    {
        $this->ciInstance = $ciInstance;
    }

    /**
     * @throws EntityAuthorizerNotFoundException
     */
    public function buildEntityAuthorizer(string $entityName): EntityAuthorizerInterface
    {
        if (!array_key_exists($entityName, self::ENTITY_AUTHORIZERS)) {
            throw new EntityAuthorizerNotFoundException(
                sprintf(
                    'EntityAuthorizer for entity %s not found',
                    $entityName
                )
            );
        }

        $authorizerClass = self::ENTITY_AUTHORIZERS[$entityName];

        switch ($entityName) {
            case Authorization::ENTITY_TYPE_ORDER:
                $this->ciInstance->load->model('Order');
                $authorizer = new $authorizerClass($this->ciInstance->Order);
                break;
            default:
                $authorizer = null;
        }

        if (empty($authorizer)) {
            throw new EntityAuthorizerNotFoundException(
                sprintf(
                    'Instantiating EntityAuthorizer for entity %s failed',
                    $entityName
                )
            );
        }

        return $authorizer;
    }
}
