<?php

namespace App\Customer\Models\Reference;

/**
 * For use in Orderrevenues controller
 */
class DeliveryNote
{
    private const REFERENCE_ID = 'DQ';
    private $db;

    public function __construct()
    {
        $ci = &get_instance();
        $this->db = $ci->db;
    }

    /**
     * @param int $customerId
     * @param string $deliveryNoteValue
     * @param string $companyCode
     * @return bool
     */
    public function exists(int $customerId, string $deliveryNoteValue, string $companyCode = '') : bool
    {
        $sql = "
                SELECT count(*) as cnt
                FROM tb_orders o
                JOIN tb_order_references r ON o.id=r.order_id
                WHERE o.customer_id = ? 
                  AND o.status != ?  
                  AND r.reference_id = ? 
                  AND r.ref_value = ? 
                  AND r.status = ?
                  AND o.company_code = ?";

        $params = [$customerId, 0, self::REFERENCE_ID, $deliveryNoteValue, 1, $companyCode];
        $result = $this->db->query($sql, $params)->row();

        return (bool)$result->cnt ?? 0;
    }

    /**
     * @param string $customerCode
     * @param string $companyCode
     * @return int
     */
    public function getCustomerIdByCustomerCode(string $customerCode, string $companyCode = '') : int
    {
        $sql = "
                SELECT id
                FROM tb_customers
                WHERE code = ? AND company_code = ? AND status = ? ORDER BY updatedon DESC LIMIT 1";
        
        $result = $this->db->query($sql, [$customerCode, $companyCode, 1])->row();

        return $result->id ?? 0;
    }
}