<?php

namespace App\EventsQueue;

use App\MobileEvents;
use CI_Controller;
use League\Event\EventDispatcher;

/**
 * Controller to extend to operate on EventDispatcher
 */
abstract class AbstractEventController extends CI_Controller
{
    /** @var EventDispatcher To dispatching events */
    protected $eventDispatcher;

    public function __construct()
    {
        parent::__construct();
        $this->load->library('uuid');
        $this->eventDispatcher = new EventDispatcher(new MobileEvents\EventListenerProvider($this->db, $this->uuid));
    }
}
