<?php

namespace App\EventsQueue;

use CI_DB_mysqli_driver;

class OldEventsRemovalService
{
    /**
     * @var CI_DB_mysqli_driver
     */
    private $db;

    public function __construct(CI_DB_mysqli_driver $db)
    {
        $this->db = $db;
    }

    public function remove(int $successfulEventsRetentionDays): void
    {
        $sql = $this->db->query(
            "DELETE from tbl_events_queue WHERE updated_on < DATE_SUB(NOW(), INTERVAL ? DAY) AND status = ?",
            [$successfulEventsRetentionDays, EventStatus::COMPLETED]
        );
        if ($sql !== true) {
            throw new OldEventsRemovalFailed("Error occured during delete query.");
        }
    }
}
