<?php

namespace App\ExceptionHandler;

final class DefaultExceptionHandler implements ExceptionHandler
{
    public function handleException(\Throwable $exception): void
    {
        $logger = $this->getLogger();
        $logger->log($exception);

        if (ApiException::isApiException($exception)) {
            (new ApiExceptionHandler())->handleException($exception);

            return;
        }

        set_status_header(500);

        if (false === filter_var(ini_get('display_errors'), FILTER_VALIDATE_BOOLEAN)) {
            echo get_instance()->load->view('errors/html/error_500', [], true);
            return;
        }

        $_error =& load_class('Exceptions', 'core');
        $_error->show_exception($exception);
    }

    private function getLogger(): LogException
    {
        if (ENVIRONMENT === 'development') {
            return new DevelopmentExceptionLogger();
        }

        return new ExceptionLogger();
    }
}
