<?php

namespace App\Mobile\V1\Authentication;

class GetShiftIdFromShipmentId
{
    public static function get(string $shipmentId, \CI_DB_mysqli_driver $db): string
    {
        $query = "SELECT
                    id, shipmentid
                    FROM tb_shifts
                    WHERE tb_shifts.shipmentid = ? limit 1";
        $row = $db->query($query, [$shipmentId])->row_array();
        if ($row === null) {
            throw new ShipmentIdNotFoundException("Shipment id not found.");
        }
        return $row['id'];
    }
}
