<?php

namespace App\Mobile\V1\Trips\Actions;

class ActionType
{
    const DELIVERY_OR_PICKUP = 1;
    const GATE_IN = 2;
    const GATE_OUT = 3;

    const PICKUP = [
        'code' => '0500',
        'status' => '1',
        'identifier' => 'pickup',
        'description' => 'Pickup'
    ];

    const DELIVERY = [
        'code' => '2300',
        'status' => '1',
        'identifier' => 'delivery',
        'description' => 'Delivery'
    ];

    const GATE_IN_PICKUP = [
        'code' => '0420',
        'status' => '2',
        'identifier' => 'gateIn',
        'description' => 'Gate in'
    ];

    const GATE_IN_DELIVERY = [
        'code' => '0192',
        'status' => '2',
        'identifier' => 'gateIn',
        'description' => 'Gate in'
    ];

    const GATE_OUT_PICKUP = [
        'code' => '0191',
        'status' => '3',
        'identifier' => 'gateOut',
        'description' => 'Gate out'
    ];

    const GATE_OUT_DELIVERY = [
        'code' => '3000',
        'status' => '3',
        'identifier' => 'gateOut',
        'description' => 'Gate out'
    ];

    public static $pickupIdentifiers = [
        self::PICKUP['identifier'] => self::PICKUP['status'],
        self::GATE_IN_PICKUP['identifier'] => self::GATE_IN_PICKUP['status'],
        self::GATE_OUT_PICKUP['identifier'] => self::GATE_OUT_PICKUP['status']
    ];

    public static $deliveryIdentifiers = [
        self::DELIVERY['identifier'] => self::DELIVERY['status'],
        self::GATE_IN_DELIVERY['identifier'] => self::GATE_IN_DELIVERY['status'],
        self::GATE_OUT_DELIVERY['identifier'] => self::GATE_OUT_DELIVERY['status']
    ];

    public static $stopTypeIdentifiers = [
        'P' => 'pickup',
        'D' => 'delivery'
    ];
}
