<?php

namespace App\Mobile\V1\Trips\Actions;

use App\ApiRequest\DataPreprocessing\BadRequestException;

class DecodeVirtualId
{
    /**
     * Fill the values for 'trip_id', 'stop_id', 'type', 'order_id'
     * Virtual identifier formed bt concatenation.
     * {trip_id}_{stop_id}_{type}_{order_id} ex: "123456_123456_gateIn_999456"
     *
     * @param array $request
     * @return array
     */
    public function decodeVirtualId(array $request): array
    {
        $values = [
            'trip_id' => 0,
            'stop_id' => 0,
            'type' => '',
            'order_id' => null,
        ];

        if (!isset($request['virtual_id'])) {
            return $values;
        }

        $keys = array_keys($values);
        $entities = explode('_', $request['virtual_id']);

        if (count($entities) < 3 || count($entities) > 4) {
            throw new BadRequestException('Invalid virtual_id in request.');
        }

        if ($entities) {
            foreach ($entities as $index => $entity) {
                if (!isset($keys[$index])) {
                    continue;
                }

                $values[$keys[$index]] = $entity;
            }
        }

        if (
            !is_numeric($values['trip_id'])
            || !is_numeric($values['stop_id'])
            || is_numeric($values['type'])
        ) {
            throw new BadRequestException('Invalid virtual_id in request.');
        }

        return $values;
    }

}
