<?php

namespace App\Mobile\V1\Trips;

use App\Mobile\V1\Trips\Model\TripStatus;
use App\ShiftsData\GetDocumentStatusAndStopsData;

class GetTripStatus
{
    /**
     * @param string $shift_id
     * @param int $trip_id
     * @param \CI_DB_mysqli_driver $db
     * @return string
     */
    public static function getTripStatus(string $shift_id, int $trip_id, \CI_DB_mysqli_driver $db): string
    {
        $stopsData = GetDocumentStatusAndStopsData::getStopsData(
            $trip_id,
            null,
            null,
            $shift_id,
            $db
        );

        $status = TripStatus::NOT_STARTED;

        foreach ($stopsData as $stopsDatum) {
            $name = $stopsDatum['status_name'];
            $statusCode = $stopsDatum['status_code'];

            if ($name === 'Accepted by Driver') {
                $status = TripStatus::NOT_STARTED;
            }

            if ($statusCode === '0219') {
                $status = TripStatus::STARTED;
            }

            if ($name === 'Closed' || $statusCode === '0218') {
                $status = TripStatus::FINISHED;
            }
        }
        return $status;
    }
}
