<?php

namespace App\Mobile\V1\Trips;

use App\Mobile\V1\Authentication\GetShiftIdFromShipmentId;

class GetTripsFromTripIds
{
    /**
     * @param array $shipmentIds
     * @param \CI_DB_mysqli_driver $db
     * @param $curtz
     * @return array
     * @throws \App\Mobile\V1\Authentication\ShipmentIdNotFoundException
     * @throws \App\ShipmentStops\OrderNotFound
     * @throws \App\ShipmentStops\ShipmentOrderStopsNotFoundException
     */
    public static function getTripsFromShipmentIds(array $shipmentIds, \CI_DB_mysqli_driver $db, $curtz): array
    {
        $trips = [];

        foreach ($shipmentIds as $shipmentId) {
            if (!empty($trip = static::getTripFromShiftId($shipmentId, $db, $curtz))) {
                $trips[] = $trip;
            }
        }

        return $trips;
    }

    /**
     * @param string $shipmentId
     * @param \CI_DB_mysqli_driver $db
     * @param string $curtz
     * @return array
     * @throws \App\Mobile\V1\Authentication\ShipmentIdNotFoundException
     * @throws \App\ShipmentStops\OrderNotFound
     * @throws \App\ShipmentStops\ShipmentOrderStopsNotFoundException
     */
    public static function getTripFromShiftId(string $shipmentId, \CI_DB_mysqli_driver $db, string $curtz): array
    {
        $shiftId = GetShiftIdFromShipmentId::get($shipmentId, $db);
        $driverTripsQuery = $db
            ->select("t.id, t.shift_id, t.driver_id")
            ->get_where("tb_trips as t", ['shift_id' => $shiftId]);
        $resultArray = $driverTripsQuery->result_array();

        if (empty($resultArray)) {
            return [];
        }
        $tripArray = $resultArray[0];
        $shiftId = $tripArray['shift_id'];
        $driverId = $tripArray['driver_id'];
        $tripId = $tripArray['id'];

        return MakeTripObject::makeTripObject($shiftId, $tripId, $driverId, $db, $curtz, $shipmentId)->toArray();
    }
}
