<?php

namespace App\Mobile\V1\Trips\Model;

class Site
{
    /**
     * @var string
     */
    private $name;
    /**
     * @var SiteAddress
     */
    private $address;
    /**
     * @var string
     */
    private $longitude;
    /**
     * @var string
     */
    private $latitude;

    public function __construct(
        string $name,
        SiteAddress $address,
        ?string $longitude,
        ?string $latitude
    ) {
        $this->name = $name;
        $this->address = $address;
        $this->longitude = $longitude;
        $this->latitude = $latitude;
    }

    public function toArray() {
        return [
            'name' => $this->name,
            'address' => $this->address->toArray(),
            'location' => [
                'lat' => is_null($this->latitude) ? null : (float) $this->latitude,
                'long' => is_null($this->longitude) ? null : (float) $this->longitude,
            ],
        ];
    }
}
