<?php

namespace App\Mobile\V1\Trips\Model;

use App\ShiftsData\TbStopStatusFields\StopType;

class SiteFactory
{
    public static function create(object $orderForShiftId, $shipType): Site {
        if (!in_array($shipType, [StopType::PICKUP, StopType::DROP])) {
            throw new \InvalidArgumentException();
        }

        if ($shipType === StopType::PICKUP) {
            $siteAddress = new SiteAddress(
                ($orderForShiftId->pickup_address1 ?? '') . ($orderForShiftId->pickup_address2 ? ', ' . $orderForShiftId->pickup_address2 : ''),
                '',
                $orderForShiftId->pickup_pincode ?? '',
                $orderForShiftId->pickup_city ?? '',
                '',
                $orderForShiftId->pickup_country ?? ''
            );
            return new Site(
                $orderForShiftId->pickup_company,
                $siteAddress,
                $orderForShiftId->plng,
                $orderForShiftId->plat
            );
        }
        $siteAddress = new SiteAddress(
            ($orderForShiftId->delivery_address1 ?? '') . ($orderForShiftId->delivery_address2 ? ', ' . $orderForShiftId->delivery_address2 : ''),
            '',
            $orderForShiftId->delivery_pincode ?? '',
            $orderForShiftId->delivery_city ?? '',
            '',
            $orderForShiftId->delivery_country ?? ''
        );
        return new Site(
            $orderForShiftId->delivery_company,
            $siteAddress,
            $orderForShiftId->dlng,
            $orderForShiftId->dlat
        );
    }
}
