<?php

namespace App\Mobile\V1\Trips\Model;

use Carbon\Carbon;

class Stop
{
    /**
     * @var int
     */
    private $id;
    /**
     * @var Site
     */
    private $site;
    /**
     * @var Carbon
     */
    private $minArrival;
    /**
     * @var Carbon
     */
    private $maxArrival;
    /**
     * @var StopAction[]
     */
    private $actions;

    public function __construct(int $id, int $sortOrder, Site $site, Carbon $minArrival, Carbon $maxArrival, StopAction ...$actions) {
        $this->id = $id;
        $this->sortOrder = $sortOrder;
        $this->site = $site;
        $this->minArrival = $minArrival;
        $this->maxArrival = $maxArrival;
        $this->actions = $actions;
    }

    public function toArray() {
        return [
            'id' => $this->id,
            'sort_order' => $this->sortOrder,
            'site' => $this->site->toArray(),
            'minArrival' => $this->minArrival->toDateTime()->format("Y-m-d\TH:iO"),
            'maxArrival' => $this->maxArrival->toDateTime()->format("Y-m-d\TH:iO"),
            'actions' => array_map(function ($action) {return $action->toArray();}, $this->actions),
        ];
    }

    /**
     * @return StopAction[]
     */
    public function getActions(): array
    {
        return $this->actions;
    }
}
