<?php

namespace App\Mobile\V1\Trips\Model;

use App\Mobile\V1\Trips\Actions\Enum\ActionState;
use App\Mobile\V1\Trips\Actions\Enum\ActionType;
use Carbon\Carbon;

class StopActionFactory
{
    /**
     * @param int $tripId
     * @param int $stopId
     * @param Carbon $minArrival
     * @param Carbon $maxArrival
     * @return StopAction
     */
    public function makeGateIn(int $tripId, int $stopId, Carbon $minArrival, Carbon $maxArrival): StopAction
    {
        return new StopAction(
            null,
            $this->getVirtualId($tripId, $stopId, ActionType::GATE_IN),
            ActionType::GATE_IN,
            "",
            $minArrival,
            $maxArrival,
            new StopActionDetails(ActionState::TO_DO, null, null, [], null, '', StopActionDetails::DEFAULT_COMMENT)
        );
    }

    /**
     * @param int $tripId
     * @param int $stopId
     * @param string $transferType
     * @param Carbon $minArrival
     * @param Carbon $maxArrival
     * @param array $merchandises
     * @return StopAction
     */
    public function makeTransfer(int $tripId, int $stopId, string $transferType, Carbon $minArrival, Carbon $maxArrival, array $merchandises): StopAction
    {
        return new StopAction(
            null,
            $this->getVirtualId($tripId, $stopId, $transferType, $merchandises[0]['orderId'] ?? null),
            $transferType,
            "",
            $minArrival,
            $maxArrival,
            new StopActionDetails(ActionState::TO_DO, null, null, [], null, '', StopActionDetails::DEFAULT_COMMENT),
            ...array_map(function (array $merchandise) {return Merchandise::fromArray($merchandise);}, $merchandises)
        );
    }

    /**
     * @param int $tripId
     * @param int $stopId
     * @param Carbon $minArrival
     * @param Carbon $maxArrival
     * @return StopAction
     */
    public function makeGateOut(int $tripId, int $stopId, Carbon $minArrival, Carbon $maxArrival): StopAction
    {
        return new StopAction(
            null,
            $this->getVirtualId($tripId, $stopId, ActionType::GATE_OUT),
            ActionType::GATE_OUT,
            "",
            $minArrival,
            $maxArrival,
            new StopActionDetails(ActionState::TO_DO, null, null, [], null, '', StopActionDetails::DEFAULT_COMMENT)
        );
    }

    /**
     * @param int $tripId
     * @param int $stopId
     * @param string $actionType
     * @param int|null $orderId
     * @return string
     */
    private function getVirtualId(int $tripId, int $stopId, string $actionType, int $orderId = null): string
    {
        if ($orderId !== null) {
            return $tripId . "_" . $stopId . "_" . $actionType . "_" . $orderId;
        }
        return $tripId . "_" . $stopId . "_" . $actionType;
    }
}
