<?php

namespace App\Mobile\V1\Trips\ReorderStops;

use App\Mobile\V1\Trips\GetShiporderStopsIdsFromTripId;

class NewOrderPersistence
{
    private $driver;
    private $commonModel;

    public function __construct(\CI_DB_mysqli_driver $driver, \Common $commonModel) {
        $this->driver = $driver;
        $this->commonModel = $commonModel;
    }

    public function persist(ReorderPayload $payload) {
        $tripId = $payload->tripId();
        $currentShiporderStops = GetShiporderStopsIdsFromTripId::get($tripId, $this->driver);
        $currentStopsById = [];
        foreach ($currentShiporderStops as $stop) {
            $currentStopsById[$stop['shiporderstop_id']] = $stop;
        }
        $this->verifyMatch($payload, $currentStopsById);
        foreach ($payload->getStops() as $payloadStop) {
            $this->update($payloadStop);
        }

    }

    private function verifyMatch(ReorderPayload $payload, array $currentStopsById) {
        $keys = array_keys($currentStopsById);
        foreach ($payload->getStops() as $payloadStop) {
            if (in_array($payloadStop->id(), $keys)) {
                continue;
            }
            throw new \Exception('Shiporder stop not found for trip.');
        }
    }

    private function update(ReorderPayloadStop $payloadStop) {
        $this->commonModel->updatetbledata('tb_shiporder_stops', ['ordernumber' => $payloadStop->sortOrder()], ['id' => $payloadStop->id()]);
    }
}
