<?php

namespace App\Mobile\V1\Trips\ReorderStops;

class ReorderPayload
{
    /**
     * @var int
     */
    private $tripId;

    /**
     * @var string
     */
    private $shipmentId;

    /**
     * @var ReorderPayloadStop[]
     */
    private $stops;

    public function __construct(int $tripId, string $shipmentId, ReorderPayloadStop ...$stops) {
        $this->tripId = $tripId;
        $this->shipmentId = $shipmentId;
        $this->stops = $stops;
    }

    public function shipmentId(): string {
        return $this->shipmentId;
    }

    public function tripId(): int {
        return $this->tripId;
    }

    public function getStops(): array {
        return $this->stops;
    }
}
