<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\AbortTripPayload;

final class AbortTripEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof AbortTripPayload) {
            throw new InvalidPayloadException;
        }
        if ($payload->getCreatedSource() == 9) {
            $postdata = $payload->toArray();
            $postdata['user_id'] = $payload->getUserId();
            $postdata['hrs'] = $payload->getOffset();
            $postdata['ord_id'] = $payload->getTripIdentity()->getOrderId();
            $postdata['status_code'] = '3060';
            $this->CI->svkonektquote->getstatusresponse($postdata);
        }
        $this->CI->statusintigration->roadlogshipmentabort($payload->toArray());
    }
}
