<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\DriverCollectionPayload;

final class DriverCollectionEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof DriverCollectionPayload) {
            throw new InvalidPayloadException;
        }

        if ($payload->isSvkonektQuotePayload() == 9) {
            $this->CI->svkonektquote->getstatusresponse($payload->getDataToSvkonektQuote());
        }

        $this->CI->statusintigration->roadlogshipmentconfirm($payload->toArray());
    }
}
