<?php

namespace App\MobileEvents\Handler;

use App\ApiRequest\SendDocumentGateOut;
use App\ApiRequest\StopUnitsPartiallyPicked;
use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\MilestoneUpdatePayload;
use App\NotificationManagement\NotificationManager;

final class MilestoneUpdateEventHandler extends MobileEventHandler
{
    /**
     * @throws \Mpdf\MpdfException
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof MilestoneUpdatePayload) {
            throw new InvalidPayloadException;
        }

        $postdata = $payload->toArray();

        if ($payload->getMilestoneOrderId() != '') {
            $ordinfo = $this->CI->common->gettblrowdata(['order_id' => $payload->getMilestoneOrderId()], 'id', 'tb_orders', 0, 0);
        }
        if ($payload->getStatusId() == 8) {
            $this->CI->statusintigration->roadlogshipcollectcancel($postdata);
        } elseif ($payload->getStatusId() == 4) {
            $this->CI->statusintigration->roadlogshipmentintransit($postdata);
        } elseif ($payload->getStatusId() == 1) {
            if ($payload->getStopType() == "D") {
                $this->CI->statusintigration->roadlogshipmentdelivered($postdata);
                if ($payload->getMilestoneOrderId() != '') {
                    $ordinfo_id = $ordinfo['id'] ?? "0";
                    if ($ordinfo_id > 0) {
                        NotificationManager::notify($this->CI, 'delivery_note', $ordinfo_id);
                    }
                }
                $stop_closed = StopUnitsPartiallyPicked::isStopUnitsPartiallyPicked($this->CI->db, $payload->getShipmentId(), $payload->getStopId());
                if ($stop_closed) {
                    $this->CI->statusintigration->roadlogshipmentdeliverpartial($postdata);
                }
            } elseif ($payload->getStopType() == "P") {
                $this->CI->statusintigration->roadlogshipmentpicked($postdata);
                if ($payload->getMilestoneOrderId() != '') {
                    $ordinfo_id = $ordinfo['id'] ?? "0";
                    if ($ordinfo_id > 0) {
                        NotificationManager::notify($this->CI, 'pickup_note', $ordinfo_id);
                    }
                }
            }
        } elseif ($payload->getStatusId() == 2) {
            if ($payload->getStopType() == "P") {
                $this->CI->statusintigration->roadlogshipmentpgatein($postdata);
            }
            if ($payload->getStopType() == "D") {
                $this->CI->statusintigration->roadlogshipmentdgatein($postdata);
            }
        } elseif ($payload->getStatusId() == 3) {
            if ($payload->getStopType() == "P") {
                $this->CI->statusintigration->roadlogshipmentpgateout($postdata);
                //log_message("error", "salog milestone  POP Payload " . json_encode($postdata));
                SendDocumentGateOut::sendepopgateoutnotify($postdata, $this->CI);
            }
            if ($payload->getStopType() == "D") {
                $this->CI->statusintigration->roadlogshipmentdgateout($postdata);
                //log_message("error", "salog milestone POD Payload " . json_encode($postdata));
                SendDocumentGateOut::sendepodgateoutnotify($postdata, $this->CI);
            }
        }
        $stscode = "0420";
        if ($payload->getStatusId() == 2 && $payload->getStopType() == "P") {
            $stscode = "0420";
        }
        if ($payload->getStatusId() == 2 && $payload->getStopType() == "D") {
            $stscode = "0192";
        }
        if ($payload->getStatusId() == 3 && $payload->getStopType() == "P") {
            $stscode = "0191";
        }
        if ($payload->getStatusId() == 3 && $payload->getStopType() == "D") {
            $stscode = "3000";
        }
        if ($payload->getStatusId() == 1 && $payload->getStopType() == "P") {
            $stscode = "0500";
        }
        if ($payload->getStatusId() == 1 && $payload->getStopType() == "D") {
            $stscode = "2300";
        }
        if ($payload->getStatusId() == 4) {
            $stscode = "1550";
        }
        if ($payload->getCreatedSource() == 5) {
            if (($stscode == "0500") || ($stscode == "2300") || ($stscode == "3000")) {
                $postdata['status_code'] = $stscode;
                $postdata['ord_id'] = $payload->getTripOrderId();
                if (!MilestoneUpdateXmlChecker::isTest()) {
                    log_message("error", "salog status" . json_encode($postdata));
                }
                $this->CI->statusintigration->salogshipmentstatus($postdata);
            }
        } elseif ($payload->getCreatedSource() == 9) {
            if ($payload->getStatusId() == '4' || ($payload->getStatusId() == "1" && $payload->getStopType() == "P") || ($payload->getStatusId() == "3" && $payload->getStopType() == "D")) {
                $postdata['user_id'] = $payload->getUserId();
                $postdata['status_code'] = $stscode;
                $postdata['ord_id'] = $payload->getTripOrderId();
                $this->CI->svkonektquote->getstatusresponse($postdata);
            }
        } elseif ($payload->getCreatedSource() == 8) {
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $payload->getCurrentTimeZoneName());
            $cur_date = $getactual['datetime'];
            $postdata['date_transmission'] = $cur_date;
            $postdata["truck_number"] = null;
            $chktruck = $this->CI->db->query("SELECT truck_number FROM tb_trucks_data WHERE id = ? LIMIT 1",[$payload->getVehicleId()]);
            if ($chktruck->num_rows() > 0) {
                $postdata["truck_number"] = $chktruck->row()->truck_number;
            }
            $postdata["edi_reference"] = null;
            $chkreference = $this->CI->common->gettblrowdata(['order_id' => $payload->getTripOrderId(), 'reference_id' => 'EDI'], 'ref_value', 'tb_order_references', 0, 0);
            if (!empty($chkreference)) {
                $postdata["edi_reference"] = $chkreference['ref_value'];
            }
            $postdata = $this->getPostData($payload->getStatusId(), $payload->getStopType(), $postdata);
            if(!empty($postdata['situation_code']) && !empty($postdata['justification_code'])) {
                $this->CI->shippeostatusintigration->shippeoStatusUpdate($postdata);
            }
        } elseif ($payload->getCreatedSource() == 12) {
            if($payload->getStatusId() == "4"){
                $sts = $this->CI->macdamstatusintigration->macdamshipmentintransit($postdata);
            }
            if($payload->getStatusId() == "2" && $payload->getStopType() == "P"){
                $sts = $this->CI->macdamstatusintigration->macdamshipmentpgatein($postdata);
            }
            if($payload->getStatusId() == "1" && $payload->getStopType() == "P"){
                $sts = $this->CI->macdamstatusintigration->macdamshipmentpicked($postdata);
            }
            if($payload->getStatusId() == "3" && $payload->getStopType() == "P"){
                $sts = $this->CI->macdamstatusintigration->macdamshipmentpgateout($postdata);
            }
            if($payload->getStatusId() == "2" && $payload->getStopType() == "D"){
                $sts = $this->CI->macdamstatusintigration->macdamshipmentdgatein($postdata);
            }
            if($payload->getStatusId() == "1" && $payload->getStopType() == "D"){
                $sts = $this->CI->macdamstatusintigration->macdamshipmentdelivered($postdata);
            }
            if($payload->getStatusId() == "3" && $payload->getStopType() == "D") {
                $sts = $this->CI->macdamstatusintigration->macdamshipmentdgateout($postdata);
            }
        }
    }

    /**
     * Prepare data to shippeo status integration update
     *
     * @param string $statusId Status of milestone
     * @param string $stopType Stop Type - P -> Pick up, D -> Delivery
     * @param array $postdata
     *
     * @return array
     */
    private function getPostData(string $statusId, string $stopType, array $postdata): array
    {
        if ($statusId == "2" && $stopType == "P") {
            // GATEIN
            $postdata['situation_code'] = 'EML';
            $postdata['justification_code'] = 'ARS';
        }
        if ($statusId == "1" && $stopType == "P") {
            // GATEIN PICKUP
            $postdata['situation_code'] = 'ECH';
            $postdata['justification_code'] = 'CFM';
        }
        if ($statusId == "4" && $stopType == "P") {
            // In-Transit
            $postdata['situation_code'] = 'MLV';
            $postdata['justification_code'] = 'CFM';
        }
        if ($statusId == "1" && $stopType == "D") {
            // Destination - delivery
            $postdata['situation_code'] = 'LIV';
            $postdata['justification_code'] = 'CFM';
        }
        if ($statusId == "3" && $stopType == "D") {
            // Destination - Gateout
            $postdata['situation_code'] = 'LIV';
            $postdata['justification_code'] = 'DES';
        }
        return $postdata;
    }
}
