<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Handler\EventHandler;
use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\MobileEventHandlerNotFoundException;
use App\MobileEvents\MobileEventType;
use CI_Controller;

class MobileEventHandler extends MobileEventType implements EventHandler
{
    protected $CI;
    protected $eventName;

    public function __construct(CI_Controller $CI, string $eventName = null)
    {
        $this->CI = $CI;
        $this->eventName = $eventName;
    }

    /**
     * @throws \Throwable
     * @throws InvalidPayloadException
     * @throws HandlerNotFoundForEventException
     */
    public function handle(EventPayload $payload): void
    {
        if (substr($this->eventName, 0, strlen($this->getEventType())) !== $this->getEventType()) {
            throw new InvalidPayloadException;
        }

        try {
            if ($handler = (new MobileEventHandlerProvider())($this->eventName)) {
                try {
                    (new $handler($this->CI))->handle($payload);
                } catch (\Throwable $ex) {
                    throw $ex;
                }

                return;
            }
        } catch (MobileEventHandlerNotFoundException $e) {
            echo('MobileEventHandler - Handler was not found for event: ' . $this->eventName . PHP_EOL);
        }

        throw new HandlerNotFoundForEventException('MobileEventHandler - Handler was not found for event: ' . $this->eventName . PHP_EOL);
    }
}
