<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\RemovePodPayload;

final class RemovePodEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof RemovePodPayload) {
            throw new InvalidPayloadException;
        }
        if ($this->CI->commonpodedi->checkDocumentType($payload->getFileType())) {
            $this->CI->commonpodedi->sendpodoutboundxml($payload->getOrderId(), $payload->getFilePath(), $payload->getFileType(), $payload->getOption());
        }
    }
}
