<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\StartMultipleShipmentsPayload;
use App\NotificationManagement\NotificationManager;

final class StartMultipleTripsEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof StartMultipleShipmentsPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->statusintigration->roadlogshipmentconfirm($payload->toArray());
        if ($payload->getCreatedSource() == 9) {
            $postdata = $payload->toArray();
            $postdata['status_code'] = '0212';
            $postdata['ord_id'] = $payload->getTripIdentity()->getOrderId();
            $postdata['user_id'] = $payload->getUserId();
            $this->CI->svkonektquote->getstatusresponse($postdata);
        }
        if ($payload->getTripIdentity()->getTripId() > 0) {
            NotificationManager::notify($this->CI, 'driver_accept', $payload->getTripIdentity()->getOrderId());
        }
    }
}
