<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\StartTripPayload;
use App\NotificationManagement\NotificationManager;

final class StartTripEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof StartTripPayload) {
            throw new InvalidPayloadException;
        }

        $orderId = $payload->getTripIdentity()->getOrderId();
        $postdata = $payload->toArray();

        $this->CI->statusintigration->roadlogshipmentconfirm($postdata);

        if ($payload->getCreatedSource() == 9) {
            $postdata['status_code'] = '0212';
            $postdata['ord_id'] = $orderId;
            $this->CI->svkonektquote->getstatusresponse($postdata);
        } elseif ($payload->getCreatedSource() == 8) {
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $payload->getCurrentTimeZone()->getName());
            $cur_date = $getactual['datetime'];
            $postdata['date_transmission'] = $cur_date;
            $postdata["truck_number"] = null;
            $chktruck = $this->CI->db->query(
                "SELECT truck_number FROM tb_trucks_data WHERE id = ? LIMIT 1",
                [$payload->getTripIdentity()->getVehicleId()]
            );
            if ($chktruck->num_rows() > 0) {
                $postdata["truck_number"] = $chktruck->row()->truck_number;
            }
            $postdata["edi_reference"] = null;
            $chkreference = $this->CI->common->gettblrowdata(
                ['order_id' => $orderId, 'reference_id' => 'EDI'],
                'ref_value',
                'tb_order_references',
                0,
                0
            );
            if (!empty($chkreference)) {
                $postdata["edi_reference"] = $chkreference['ref_value'];
            }
            $postdata['situation_code'] = 'EML';
            $postdata['justification_code'] = 'CFM';
            $this->CI->shippeostatusintigration->shippeoStatusUpdate($postdata);
        }
        $chqry = $this->CI->db->select("id")->get_where(
            "tb_stop_status",
            [
                "shipment_id" => $payload->getTripIdentity()->getShiftId(),
                "stop_id" => 0,
                "stop_detail_id" => 0,
                "trip_id" => $payload->getTripIdentity()->getTripId(),
                "status_id" => 10
            ],
            1,
            0
        );
        if ($chqry->num_rows() == 0) {
            $emps = $this->CI->db->where(["shift_id" => $payload->getTripIdentity()->getShiftId(), 'status' => "1"])->get("tb_employee");
            foreach ($emps->result() as $emp) {
                $orders = $this->CI->db->where(["order_id" => $emp->order_id])->get("tb_orders");
                if ($orders->num_rows() > 0) {
                    $insarry = [
                        "shipment_id" => $payload->getTripIdentity()->getShiftId(),
                        "stop_id" => 0,
                        "stop_detail_id" => 0,
                        "stop_type" => '',
                        "trip_id" => $payload->getTripIdentity()->getTripId(),
                        "status_id" => 10,
                        "latitude" => $payload->getPosition()->getLatitude(),
                        "longitude" => $payload->getPosition()->getLongitude(),
                        "status" => 1,
                        "status_code" => "0212",
                        "reason" => "From Mobile",
                        "vehicle_id" => $payload->getTripIdentity()->getVehicleId(),
                        "driver_id" => $payload->getTripIdentity()->getDriverId(),
                        "createdon" => $payload->getCurrentDateTime()->format('Y-m-d H:i:s'),
                        "order_id" => $orders->row()->id
                    ];

                    $this->CI->db->insert("tb_stop_status", $insarry);
                }
            }
        }
        if (empty($orderId)) {
            NotificationManager::notify($this->CI, 'driver_accept', $orderId);
        }
    }
}
