<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\StopStatusUpdatePayload;

final class StopStatusUpdateEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof StopStatusUpdatePayload) {
            throw new InvalidPayloadException;
        }

        if ($payload->isAllAccepted()) {
            $this->CI->statusintigration->roadlogshipmentcollected($payload->toArray());
        } else {
            $this->CI->statusintigration->roadlogshipnotcollected($payload->toArray());
        }
    }
}
