<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\UploadCustomsPayload;

final class UploadCustomsEventHandler extends MobileEventHandler
{
    /**
     * @throws InvalidPayloadException
     */
    public function handle(EventPayload $payload): void
    {
        if (!$payload instanceof UploadCustomsPayload) {
            throw new InvalidPayloadException;
        }

        $this->CI->statusintigration->roadlogcustomsdocstatus($payload->toArray());
        if ($payload->getDocument()->getFileName() != "") {
            $this->sendCustomsNotify($payload->toArray());
        }
        if ($payload->getCreatedSource() == 9) {
            $postData = $payload->toArray();
            $postData['user_id'] = $payload->getUserId();
            $postData['ord_id'] = $payload->getOrder();
            $postData['status_code'] = '3060';
            $this->CI->svkonektquote->getstatusresponse($postData);
        }
    }

    public function sendCustomsNotify($post): void
    {
        $shipment_id = $post["user_id"] ?? '';
        $user_id = $post["user_id"] ?? '';
        $driver_id = $post["driver_id"] ?? '';
        $trip_id = $post["trip_id"] ?? '';
        $order_id = $post["order_id"] ?? '';
        if ($user_id == "" || $driver_id == "" || $trip_id == "") {
            return;
        }
        $getusermail = $this->CI->db->select("name,emailid,company_code,cc_mails")->get_where("tb_users", array("id" => $user_id, "status" => "Active"), 1, 0);
        if ($getusermail->num_rows() == 0) {
            return;
        }
        $cmpcode = $getusermail->row()->company_code;
        if ($cmpcode == "SGKN" || $cmpcode == "MYKN") {
            $receivemail = $getusermail->row()->cc_mails;
            $receivename = $getusermail->row()->name;
            if ($receivemail == "") {
                $receivemail = $getusermail->row()->emailid;
            }
        } else {
            $receivemail = $getusermail->row()->emailid;
            $receivename = $getusermail->row()->name;
        }
        $orddata = $this->CI->db->query("SELECT * FROM tb_orders WHERE order_id=? AND shift_id=? LIMIT 1", [$order_id, $shipment_id]);
        if ($orddata->num_rows() == 0) {
            return;
        }
        $orddata1 = $orddata->row_array();
        $data['order_id'] = $orddata1['order_id'];
        $customer_id = $orddata1['customer_id'];
        $custname = $custemail = "";
        $customer = $this->CI->db->query("SELECT name,email_id FROM tb_customers WHERE id = ? AND email_id != ? AND status = ? LIMIT 1", [$customer_id, '', 1]);
        if ($customer->num_rows() > 0) {
            $custname = $customer->row()->name;
            $custemail = $customer->row()->email_id;
        }
        $this->CI->load->library('email');
        $data['orderref'] = "";
        $ordref = $this->CI->db->select("ref_value")->get_where("tb_order_references", array("order_id" => $order_id, "reference_id" => "DQ"), 1, 0);
        if ($ordref->num_rows() > 0) {
            $data['orderref'] = $ordref->row()->ref_value;
        }
        $data['order'] = $orddata1;
        $data['page_title'] = "Cross Border Shipment";
        $data['receivemail'] = $receivemail;
        $this->CI->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->CI->email->to($receivemail);

        if ($custname != "") {
            $this->CI->email->bcc($custemail, $custname);
        }
        $data['subject'] = "Customs Clearance Completed at Border for Shipment #" . $order_id;
        $this->CI->email->subject("svkonekt::Customs Clearance Completed at Border for Shipment #" . $order_id);
        $this->CI->email->set_mailtype("html");
        $data['receivename'] = "Team";
        $body = $this->CI->load->view('mail_forms/crossborder', $data, true);
        $this->CI->email->message($body);
        $this->CI->email->send();
        $this->CI->email->clear(true);
    }
}
