<?php

namespace App\MobileEvents\Handler;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\UploadGeneratedEpodPayload;

final class UploadGeneratedEpodHandler extends MobileEventHandler
{
    public function handle(EventPayload $payload): void
    {
        /** @var UploadGeneratedEpodPayload $payload */
        if (!$payload instanceof UploadGeneratedEpodPayload) {
            throw new InvalidPayloadException;
        }

        $ci = &get_instance();
        $ci->load->library("commonpodedi");
        /** @var \Commonpodedi $cpe */
        $cpe = $ci->commonpodedi;
        $cpe->sendpodoutboundxml($payload->getTripIdentity()->getOrderId(), $payload->getEpodFileName(), '1');
    }
}
