<?php

namespace App\MobileEvents;

use App\EventsQueue\Payload\EventPayload;
use League\Event\HasEventName;

/**
 * Mobile event
 */
class MobileEvent implements HasEventName
{
    const EVENT_START_TRIP = "mobile.event.startTrip";
    const EVENT_START_MULTIPLE_SHIPMENTS = "mobile.event.startMultipleShipments";
    const EVENT_CLOSE_TRIP = "mobile.event.closeTrip";
    const EVENT_CLOSE_TRIP_GENERATE_SUMMARY = "mobile.event.closeTrip.generatesummary";
    const EVENT_CLOSE_TRIP_NOTIFY_OPENBOXES = "mobile.event.closeTrip.notifyOpenBoxes";
    const EVENT_CLOSE_TRIP_FROM_WEB = "mobile.event.closeTripfromweb";
    const EVENT_UPLOAD_POD = "mobile.event.poduploads";
    const EVENT_UPLOAD_GENERATED_EPOD = "mobile.event.uploadGeneratedEpod";
    const EVENT_UPLOAD_SIGNATURE = "mobile.event.signatureUpload";
    const EVENT_MILESTONE_STATUS = "mobile.event.setShipstopStatus";
    const EVENT_REJECT_TRIP = "mobile.event.setShipReject";
    const EVENT_ABORT_TRIP = "mobile.event.setshipAbort";
    const EVENT_RESCHEDULE_TRIP = "mobile.event.rescheduleShift";
    const EVENT_STOP_STATUS_UPDATE = "mobile.event.stopdetailsaccept";
    const EVENT_ASSIGN_DRIVER = "mobile.event.assigndriver";
    const EVENT_UPLOAD_CUSTOMS = "mobile.event.uploadcostomes";
    const EVENT_REMOVE_POD = "mobile.event.removestoppod";
    const EVENT_DRIVER_COLLECTION = "mobile.event.drivercollection";
    const EVENT_PANIC_ALERT = "mobile.event.panicAlert";
    const EVENT_DUMMY = "mobile.event.dummy";

    /** @var string Event name */
    private $name;

    /** @var EventPayload Payload contains extra data which might be use by handlers */
    private $payload;

    public function __construct(string $name, EventPayload $payload)
    {
        $this->name = $name;
        $this->payload = $payload;
    }

    /**
     * @return string
     */
    public function eventName(): string
    {
        return $this->name;
    }

    /**
     * @return EventPayload
     */
    public function payload(): EventPayload
    {
        return $this->payload;
    }
}
