<?php

namespace App\MobileEvents\Payload;

use App\EventsQueue\Payload\EventPayload;
use Exception;

final class AssignDriverPayload implements EventPayload
{

    /** @var string */
    private $driverId;

    /** @var string */
    private $message;

    /**
     * @param string $driverId
     * @param string $message
     * @throws Exception
     */
    public function __construct(string $message, string $driverId)
    {
        $this->driverId = $driverId;
        $this->message = $message;

        if ($this->validatePayload() === false) {
            throw new Exception('Assign driver is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return !empty($this->getDriverId()) &&
            !empty($this->getMessage());
    }

    /**
     * @return string
     */
    public function getDriverId(): string
    {
        return $this->driverId;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    public function toArray(): array
    {
        return [
            "title" => "Change Driver To Trip",
            "message" => $this->getMessage(),
            "emp_id" => $this->getDriverId(),
            'type' => 'Driver'
        ];
    }
}