<?php

namespace App\MobileEvents\Payload\Carrier;

final class CarrierIdentity
{
    /** @var string */
    private $email;

    /** @var string */
    private $name;

    /**
     * @param string $email
     * @param string $name
     */
    public function __construct(string $email, string $name)
    {
        $this->email = $email;
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }
}