<?php

namespace App\MobileEvents\Payload;

use App\EventsQueue\Payload\EventPayload;

final class CloseTripOpenboxesPayload implements EventPayload
{
    private string $status;
    private string $orderRowId;
    private string $tripId;
    private \DateTime $dateTime;
    private string $lat;
    private string $long;

    public function __construct(
        string $status,
        string $orderRowId,
        string $tripId,
        \DateTime $dateTime,
        string $lat,
        string $long
    ) {
        $this->status = $status;
        $this->orderRowId = $orderRowId;
        $this->tripId = $tripId;
        $this->dateTime = $dateTime;
        $this->lat = $lat;
        $this->long = $long;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getOrderRowId(): string
    {
        return $this->orderRowId;
    }

    /**
     * @return string
     */
    public function getFormattedDateTime(): string
    {
        return $this->dateTime->format('Y-m-d H:i:s');
    }

    /**
     * @return string
     */
    public function getLat(): string
    {
        return $this->lat;
    }

    /**
     * @return string
     */
    public function getLong(): string
    {
        return $this->long;
    }

}
