<?php

namespace App\MobileEvents\Payload;

use App\EventsQueue\Payload\EventPayload;

final class CloseTripSummaryPayload implements EventPayload
{
    /** @var string */
    private $tripId;

    /** @var \DateTimeZone */
    private $currentTimeZone;

    public function __construct(string $tripId, \DateTimeZone $currentTimeZone)
    {
        $this->tripId = $tripId;
        $this->currentTimeZone = $currentTimeZone;
    }

    /**
     * @return string
     */
    public function getTripId(): string
    {
        return $this->tripId;
    }

    /**
     * @return string
     */
    public function getCurrentTimeZoneName(): string
    {
        return $this->currentTimeZone->getName();
    }
}