<?php

namespace App\MobileEvents\Payload\Driver;


use Exception;

final class DriverIdentity
{
    /**
     * @var string
     */
    private $contactNumber;
    /**
     * @var string
     */
    private $name;

    /**
     * @param string $contactNumber
     * @param string $name
     * @throws Exception
     */
    public function __construct(string $contactNumber, string $name)
    {
        $this->contactNumber = $contactNumber;
        $this->name = $name;

        if ($this->validatePayload() === false) {
            throw new Exception('Driver is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return
            !empty($this->getName()) &&
            !empty($this->getContactNumber());
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getContactNumber(): string
    {
        return $this->contactNumber;
    }

}