<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\CloseTripPayload;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeZone;

final class CloseTripPayloadFactory
{
    public static function create(
        string $isStopUnitsPartiallyPicked,
        string $shipmentId,
        string $tripId,
        string $driverId,
        string $orderId,
        string $latitude,
        string $longitude,
        string $currentTimeZone,
        string $hrs,
        string $companyCode,
        \DateTime $dateTime
    ): CloseTripPayload {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, '-1', $driverId, '-1', $tripId);

        $currentTimeZone = new DateTimeZone($currentTimeZone);

        return new CloseTripPayload(
            (bool)$isStopUnitsPartiallyPicked,
            $shipmentId,
            $tripIdentity,
            $position,
            $currentTimeZone,
            $hrs,
            $companyCode,
            $dateTime
        );
    }
}
