<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Document\UploadDocument;
use App\MobileEvents\Payload\Milestone\MilestoneIdentity;
use App\MobileEvents\Payload\PodUploadsPayload;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeImmutable;
use DateTimeZone;
use Exception;

final class PodUploadsPayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $createdSource,
        string $orderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        string $currentDateTime,
        string $currentTimeZone,
        string $offset,
        string $stopId,
        string $legOrderId,
        string $transactionCode,
        string $incrementId,
        string $statusId,
        string $stopType,
        string $documentType,
        string $fileName,
        string $fileType
    ): PodUploadsPayload {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentDateTime = new DateTimeImmutable($currentDateTime);
        $currentTimeZone = new DateTimeZone($currentTimeZone);

        $document = new UploadDocument($fileName, $fileType, $documentType, null);
        $milestone = new MilestoneIdentity($stopId, $legOrderId, $transactionCode, $incrementId, $statusId, $stopType);

        return new PodUploadsPayload($tripIdentity, $position, $createdSource, $userId, $currentDateTime, $currentTimeZone, $offset, $milestone, $document);
    }
}
