<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Carrier\CarrierIdentity;
use App\MobileEvents\Payload\Driver\DriverIdentity;
use App\MobileEvents\Payload\RescheduleTripPayload;
use App\MobileEvents\Payload\Shift\ShiftIdentity;
use App\MobileEvents\Payload\User\UserIdentity;
use Exception;

final class RescheduleTripPayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $vendorEmail,
        string $vendorName,
        string $userEmail,
        string $userName,
        string $shipmentId,
        string $startDate,
        string $startPlace,
        string $endPlace,
        string $driverName,
        string $driverContact,
        string $check,
        string $rescheduleDate,
        string $reason
    ): RescheduleTripPayload {
        $carrier = new CarrierIdentity($vendorEmail, $vendorName);
        $user = new UserIdentity($userEmail, $userName);
        $shift = new ShiftIdentity($shipmentId, $startDate, $startPlace, $endPlace);
        $driver = new DriverIdentity($driverContact, $driverName);

        return new RescheduleTripPayload($carrier, $driver, $shift, $user, $check, $reason, $rescheduleDate);
    }
}