<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Document\UploadDocument;
use App\MobileEvents\Payload\Milestone\MilestoneIdentity;
use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\SignatureUploadsPayload;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use App\PodUploads\MakePod\PodData;
use DateTimeImmutable;
use DateTimeZone;
use Exception;

final class SignatureUploadsPayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $createdSource,
        string $orderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        string $currentDateTime,
        string $currentTimeZone,
        string $offset,
        string $stopId,
        string $legOrderId,
        string $transactionCode,
        string $incrementId,
        string $statusId,
        string $stopType,
        string $documentType,
        string $fileName,
        string $fileType,
        PodData $podData,
        ?string $stopDetailId
    ): SignatureUploadsPayload {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentDateTimeObject = new DateTimeImmutable($currentDateTime);
        $currentTimeZoneObject = new DateTimeZone($currentTimeZone);

        $document = new UploadDocument($fileName, $fileType, $documentType, null);
        $milestone = new MilestoneIdentity($stopId, $legOrderId, $transactionCode, $incrementId, $statusId, $stopType);

        return new SignatureUploadsPayload($tripIdentity, $position, $createdSource, $userId, $currentDateTimeObject, $currentTimeZoneObject, $offset, $milestone, $document, $podData, $stopDetailId);
    }
}
