<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\StartMultipleShipmentsPayload;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeImmutable;
use DateTimeZone;

final class StartMultipleShipmentsPayloadFactory
{
    public static function create(
        string $createdSource,
        string $orderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        ?string $latitude,
        ?string $longitude,
        string $userId,
        string $currentDateTime,
        string $currentTimeZone,
        string $offset
    ): StartMultipleShipmentsPayload {
        $position = new OptionalPosition($latitude ?? '', $longitude ?? '');
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentDateTime = new DateTimeImmutable($currentDateTime);
        $currentTimeZone = new DateTimeZone($currentTimeZone);

        return new StartMultipleShipmentsPayload($tripIdentity, $position, $createdSource, $userId, $currentDateTime, $currentTimeZone, $offset);
    }
}
