<?php

namespace App\MobileEvents\Payload\Factory;

use App\MobileEvents\Payload\Position\OptionalPosition;
use App\MobileEvents\Payload\StopStatusUpdatePayload;
use App\MobileEvents\Payload\Trip\RequiredTripIdentity;
use DateTimeZone;
use Exception;

final class StopStatusUpdatePayloadFactory
{
    /**
     * @throws Exception
     */
    public static function create(
        string $orderId,
        string $vehicleId,
        string $driverId,
        string $shiftId,
        string $tripId,
        string $latitude,
        string $longitude,
        string $userId,
        bool   $allAccepted,
        string $stopId,
        string $currentTimeZone,
        string $offset
    ): StopStatusUpdatePayload
    {
        $position = new OptionalPosition($latitude, $longitude);
        $tripIdentity = new RequiredTripIdentity($orderId, $vehicleId, $driverId, $shiftId, $tripId);

        $currentTimeZone = new DateTimeZone($currentTimeZone);

        return new StopStatusUpdatePayload($tripIdentity, $position, $userId, $allAccepted, $stopId, $currentTimeZone, $offset);
    }
}