<?php

namespace App\MobileEvents\Payload\Milestone;

use Exception;

final class MilestoneIdentity
{
    /**
     * @var string
     */
    private $stopId;
    /**
     * @var string
     */
    private $orderId;
    /**
     * @var string
     */
    private $transactionCode;
    /**
     * @var string
     */
    private $incrementId;
    /**
     * @var string
     */
    private $statusId;
    /**
     * @var string
     */
    private $stopType;

    /**
     * @param string $stopId
     * @param string $orderId
     * @param string $transactionCode
     * @param string $incrementId
     * @param string $statusId
     * @param string $stopType
     * @throws Exception
     */
    public function __construct(string $stopId, string $orderId, string $transactionCode, string $incrementId, string $statusId, string $stopType)
    {
        $this->stopId = $stopId;
        $this->orderId = $orderId;
        $this->transactionCode = $transactionCode;
        $this->incrementId = $incrementId;
        $this->statusId = $statusId;
        $this->stopType = $stopType;

        if ($this->validatePayload() === false) {
            throw new Exception('MileStone identity is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return
            !empty($this->getStopId()) &&
            !empty($this->getOrderId()) &&
            !empty($this->getIncrementId()) &&
            !empty($this->getStatusId()) &&
            !empty($this->getStopType());
    }

    /**
     * @return string
     */
    public function getStopId(): string
    {
        return $this->stopId;
    }

    /**
     * @return string
     */
    public function getOrderId(): string
    {
        return $this->orderId;
    }

    /**
     * @return string
     */
    public function getTransactionCode(): string
    {
        return $this->transactionCode;
    }

    /**
     * @return string
     */
    public function getIncrementId(): string
    {
        return $this->incrementId;
    }

    /**
     * @return string
     */
    public function getStatusId(): string
    {
        return $this->statusId;
    }

    /**
     * @return string
     */
    public function getStopType(): string
    {
        return $this->stopType;
    }
}
