<?php

namespace App\MobileEvents\Payload;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\Driver\DriverIdentity;
use App\MobileEvents\Payload\Position\Position;
use App\MobileEvents\Payload\User\UserIdentity;
use Exception;

final class PanicAlertPayload implements EventPayload
{
    /** @var Position */
    private $position;

    /** @var UserIdentity */
    private $userIdentity;

    /** @var DriverIdentity */
    private $driverIdentity;

    /** @var string */
    private $registerNumber;

    /** @var string */
    private $shipmentId;

    /** @var string */
    private $startPlace;

    /** @var string */
    private $endPlace;

    /**
     * @param Position $position
     * @param UserIdentity $userIdentity
     * @param DriverIdentity $driverIdentity
     * @param string $registerNumber
     * @param string $shipmentId
     * @param string $startPlace
     * @param string $endPlace
     * @throws Exception
     */
    public function __construct(Position $position, UserIdentity $userIdentity, DriverIdentity $driverIdentity, string $registerNumber, string $shipmentId, string $startPlace, string $endPlace)
    {
        $this->position = $position;
        $this->userIdentity = $userIdentity;
        $this->registerNumber = $registerNumber;
        $this->driverIdentity = $driverIdentity;
        $this->shipmentId = $shipmentId;
        $this->startPlace = $startPlace;
        $this->endPlace = $endPlace;

        if ($this->validatePayload() === false) {
            throw new Exception('Panic alert is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return !empty($this->shipmentId) &&
            !empty($this->startPlace) &&
            !empty($this->endPlace);
    }

    public function toArray(): array
    {
        return [
            "name" => $this->userIdentity->getName(),
            "register_number" => $this->registerNumber,
            "lat" => $this->position->getLatitude(),
            "lng" => $this->position->getLongitude(),
            "driver_name" => $this->driverIdentity->getName(),
            "driver_mobile" => $this->driverIdentity->getContactNumber(),
            "shipment_id" => $this->shipmentId,
            "splace" => $this->startPlace,
            "eplace" => $this->endPlace,
        ];
    }

    /**
     * @return string
     */
    public function getUserEmail(): string
    {
        return $this->userIdentity->getEmail();
    }

    /**
     * @return string
     */
    public function getRegisterNumber(): string
    {
        return $this->registerNumber;
    }
}