<?php

namespace App\MobileEvents\Payload;

use App\EventsQueue\Payload\EventPayload;
use Exception;

final class RemovePodPayload implements EventPayload
{
    /** @var string */
    private $orderId;

    /** @var string */
    private $filePath;

    /** @var string */
    private $fileType;

    /** @var string */
    private $option;

    /**
     * @param string $orderId
     * @param string $filePath
     * @param string $fileType
     * @param string $option
     * @throws Exception
     */
    public function __construct(string $orderId, string $filePath, string $fileType, string $option)
    {
        $this->orderId = $orderId;
        $this->filePath = $filePath;
        $this->fileType = $fileType;
        $this->option = $option;

        if ($this->validatePayload() === false) {
            throw new Exception('Remove pod is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return !empty($this->getOrderId()) &&
            !empty($this->getOption());
    }
    /**
     * @return string
     */
    public function getOrderId(): string
    {
        return $this->orderId;
    }

    /**
     * @return string
     */
    public function getFilePath(): string
    {
        return $this->filePath;
    }

    /**
     * @return string
     */
    public function getFileType(): string
    {
        return $this->fileType;
    }

    /**
     * @return string
     */
    public function getOption(): string
    {
        return $this->option;
    }


}