<?php

namespace App\MobileEvents\Payload;

use App\EventsQueue\Payload\EventPayload;
use App\MobileEvents\Payload\Carrier\CarrierIdentity;
use App\MobileEvents\Payload\Driver\DriverIdentity;
use App\MobileEvents\Payload\Shift\ShiftIdentity;
use App\MobileEvents\Payload\User\UserIdentity;
use Exception;

final class RescheduleTripPayload implements EventPayload
{
    /**
     * @var CarrierIdentity
     */
    private $carrier;
    /**
     * @var DriverIdentity
     */
    private $driver;
    /**
     * @var ShiftIdentity
     */
    private $shift;
    /**
     * @var UserIdentity
     */
    private $user;
    /**
     * @var string
     */
    private $check;
    /**
     * @var string
     */
    private $reason;
    /**
     * @var string
     */
    private $rescheduleDate;

    /**
     * @param CarrierIdentity $carrier
     * @param DriverIdentity $driver
     * @param ShiftIdentity $shift
     * @param UserIdentity $user
     * @param string $check
     * @param string $reason
     * @param string $rescheduleDate
     * @throws Exception
     */
    public function __construct(
        CarrierIdentity $carrier,
        DriverIdentity $driver,
        ShiftIdentity $shift,
        UserIdentity $user,
        string $check,
        string $reason,
        string $rescheduleDate
    ) {
        $this->carrier = $carrier;
        $this->driver = $driver;
        $this->shift = $shift;
        $this->user = $user;
        $this->check = $check;
        $this->reason = $reason;
        $this->rescheduleDate = $rescheduleDate;

        if ($this->validatePayload() === false) {
            throw new Exception('RescheduleTripPayload is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return
            !empty($this->getRescheduleDate()) &&
            !empty($this->getReason());
    }

    /**
     * @return string
     */
    public function getRescheduleDate(): string
    {
        return $this->rescheduleDate;
    }

    /**
     * @return string
     */
    public function getReason(): string
    {
        return $this->reason;
    }

    /**
     * @return CarrierIdentity
     */
    public function getCarrier(): CarrierIdentity
    {
        return $this->carrier;
    }

    /**
     * @return DriverIdentity
     */
    public function getDriver(): DriverIdentity
    {
        return $this->driver;
    }

    /**
     * @return ShiftIdentity
     */
    public function getShift(): ShiftIdentity
    {
        return $this->shift;
    }

    /**
     * @return UserIdentity
     */
    public function getUser(): UserIdentity
    {
        return $this->user;
    }

    /**
     * @return string
     */
    public function getCheck(): string
    {
        return $this->check;
    }
}