<?php

namespace App\MobileEvents\Payload\Shift;


use Exception;

class ShiftIdentity
{
    /**
     * @var string
     */
    private $shipmentId;
    /**
     * @var string
     */
    private $startDate;
    /**
     * @var string
     */
    private $startPlace;
    /**
     * @var string
     */
    private $endPlace;

    /**
     * @param string $shipmentId
     * @param string $startDate
     * @param string $startPlace
     * @param string $endPlace
     * @throws Exception
     */
    public function __construct(string $shipmentId, string $startDate, string $startPlace, string $endPlace)
    {
        $this->shipmentId = $shipmentId;
        $this->startDate = $startDate;
        $this->startPlace = $startPlace;
        $this->endPlace = $endPlace;

        if ($this->validatePayload() === false) {
            throw new Exception('Shift is invalid');
        }
    }

    private function validatePayload(): bool
    {
        return
            !empty($this->getStartDate()) &&
            !empty($this->getShipmentId());
    }

    /**
     * @return string
     */
    public function getStartDate(): string
    {
        return $this->startDate;
    }

    /**
     * @return string
     */
    public function getShipmentId(): string
    {
        return $this->shipmentId;
    }

    /**
     * @return string
     */
    public function getStartPlace(): string
    {
        return $this->startPlace;
    }

    /**
     * @return string
     */
    public function getEndPlace(): string
    {
        return $this->endPlace;
    }
}