<?php

namespace App\MobileEvents\Payload\Trip;

use Exception;

abstract class TripIdentity
{
    /**
     * @var string
     */
    protected $orderId;
    /**
     * @var string
     */
    protected $vehicleId;
    /**
     * @var string
     */
    protected $driverId;
    /**
     * @var string
     */
    protected $shiftId;
    /**
     * @var string
     */
    protected $tripId;

    /**
     * @param string $orderId
     * @param string $vehicleId
     * @param string $driverId
     * @param string $shiftId
     * @param string $tripId
     * @throws Exception
     */
    public function __construct(string $orderId, string $vehicleId, string $driverId, string $shiftId, string $tripId)
    {
        $this->orderId = $orderId;
        $this->vehicleId = $vehicleId;
        $this->driverId = $driverId;
        $this->shiftId = $shiftId;
        $this->tripId = $tripId;
        if ($this->validatePayload() === false) {
            throw new Exception('Trip identity is invalid');
        }
    }

    abstract protected function validatePayload(): bool;

    /**
     * @return string
     */
    public function getOrderId(): string
    {
        return $this->orderId;
    }

    /**
     * @return string
     */
    public function getVehicleId(): string
    {
        return $this->vehicleId;
    }

    /**
     * @return string
     */
    public function getDriverId(): string
    {
        return $this->driverId;
    }

    /**
     * @return string
     */
    public function getShiftId(): string
    {
        return $this->shiftId;
    }

    /**
     * @return string
     */
    public function getTripId(): string
    {
        return $this->tripId;
    }
}
