<?php

namespace App\Order\Models;

class OrderReference
{
    /**
     * @var object
     */
    private $db;

    public function __construct()
    {
        $ci = &get_instance();
        $this->db = $ci->db;
    }

    /**
     * @param int $orderId
     * @param string[] $referenceIds for exampe: ['DQ', 'AWB']
     * @return bool
     */
    public function deleteForOrder(int $orderId, array $referenceIds = []) : bool
    {
        $sql = "UPDATE tb_order_references SET status = ?, updatedon = ? WHERE order_id = ?";

        if (!empty($referenceIds)) {
            $sql .= " AND reference_id IN ('" . implode( "','", $referenceIds ) . "')";
        }

        return $this->db->query($sql, [0, date('Y-m-d H:i:s'), $orderId]);
    }

    /**
     * @param int $shiftId
     * @param string[] $referenceIds
     * @return mixed
     */
    public function deleteForShift(int $shiftId, array $referenceIds = []) : bool
    {
        $sql = "UPDATE tb_order_references ref
                JOIN tb_orders o ON o.id = ref.order_id
                    SET ref.status = ?, ref.updatedon = ?
                WHERE o.shift_id = ?";

        if (!empty($referenceIds)) {
            $sql .= " AND reference_id IN ('" . implode( "','", $referenceIds ) . "')";
        }

        return $this->db->query($sql, [0, date('Y-m-d H:i:s'), $shiftId]);
    }
}