<?php
namespace App\Pagination;

class GetArgumentsResolver
{
    public function resolve(array $defaults = [], array $getArguments = [], array $ignoredArgumentKeys = []): array
    {
        $getArguments = $this->mergePresetArgumentsWithGetSuperGlobal($getArguments);
        $getArguments = $this->filterEmptyValues($getArguments);

        return $this->setDefaultsIfNoArguments($getArguments, $ignoredArgumentKeys, $defaults);
    }

    /**
     * @param array $getArguments
     * @param array $ignoredArgumentKeys
     * @param array $defaults
     * @return array
     */
    public function setDefaultsIfNoArguments(array $getArguments, array $ignoredArgumentKeys, array $defaults): array
    {
        $diffResult = array_diff(
            array_keys($getArguments),
            $ignoredArgumentKeys
        );

        if (! empty($diffResult)) {
            return $getArguments;
        }

        return array_merge(
            $defaults,
            $getArguments
        );
    }

    private function filterEmptyValues(array $getArguments): array
    {
        return array_filter(
            $getArguments,
            static function ($value) {
                return ! empty($value);
            }
        );
    }

    private function mergePresetArgumentsWithGetSuperGlobal(array $getArguments): array
    {
        return array_merge(
            filter_var_array($_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS) ?? [],
            $getArguments
        );
    }
}
