<?php

namespace App\PalletLabel\Zpl;

use App\PalletLabel\Label;

abstract class AbstractLabel implements Label
{
    /** @var string ZPL template */
    protected string $template;

    /** @var array Data used to build a template */
    protected array $labelData;

    public function __construct(array $labelData)
    {
        $this->template = file_get_contents(
            __DIR__ . DIRECTORY_SEPARATOR . 'Template' . DIRECTORY_SEPARATOR . 'GenericTemplate.zpl'
        );
        $this->labelData = $labelData;
        $this->labelData['logo'] = $this->logo();
        $this->labelData['specialInstructions'] = $this->specialInstructions();
        $this->labelData['staticText'] = $this->staticText();
    }

    public function label(): string
    {
        return vsprintf($this->template, array_values(LabelMapper::convertToZplData($this->labelData)));
    }

    public function specialInstructions(): string
    {
        if (!empty($this->labelData['store_timings'])
            && !empty($this->labelData['store_timings']['dock_hours'])
            && !empty($this->labelData['store_timings']['days'])) {
            $specialInstructionsTemplate = file_get_contents(
                __DIR__ . DIRECTORY_SEPARATOR . 'Template' . DIRECTORY_SEPARATOR . 'SpecialInstructions.zpl'
            );
            return vsprintf($specialInstructionsTemplate, [
                $this->labelData['store_timings']['dock_hours'],
                $this->labelData['store_timings']['days']
            ]);
        }
        return '';
    }

    public function staticText(): string
    {
        if (isset($this->labelData['static_text'])) {

            return file_get_contents(
                __DIR__ . DIRECTORY_SEPARATOR . 'Template' . DIRECTORY_SEPARATOR . 'StaticText.zpl'
            );
        }

        return '';
    }
}
